/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Video
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.video.v1.room.participant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.type.SubscribeRule;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class SubscribeRules extends Resource {

    private static final long serialVersionUID = 5507350376020L;

    public static SubscribeRulesFetcher fetcher(
        final String pathRoomSid,
        final String pathParticipantSid
    ) {
        return new SubscribeRulesFetcher(pathRoomSid, pathParticipantSid);
    }

    public static SubscribeRulesUpdater updater(
        final String pathRoomSid,
        final String pathParticipantSid
    ) {
        return new SubscribeRulesUpdater(pathRoomSid, pathParticipantSid);
    }

    /**
     * Converts a JSON String into a SubscribeRules object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return SubscribeRules object represented by the provided JSON
     */
    public static SubscribeRules fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, SubscribeRules.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a SubscribeRules object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return SubscribeRules object represented by the provided JSON
     */
    public static SubscribeRules fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, SubscribeRules.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String participantSid;
    private final String roomSid;
    private final List<SubscribeRule> rules;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;

    @JsonCreator
    private SubscribeRules(
        @JsonProperty("participant_sid") final String participantSid,
        @JsonProperty("room_sid") final String roomSid,
        @JsonProperty("rules") final List<SubscribeRule> rules,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_updated") final String dateUpdated
    ) {
        this.participantSid = participantSid;
        this.roomSid = roomSid;
        this.rules = rules;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getParticipantSid() {
        return this.participantSid;
    }

    public final String getRoomSid() {
        return this.roomSid;
    }

    public final List<SubscribeRule> getRules() {
        return this.rules;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        SubscribeRules other = (SubscribeRules) o;

        return (
            Objects.equals(participantSid, other.participantSid) &&
            Objects.equals(roomSid, other.roomSid) &&
            Objects.equals(rules, other.rules) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateUpdated, other.dateUpdated)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            participantSid,
            roomSid,
            rules,
            dateCreated,
            dateUpdated
        );
    }
}
