/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Voice
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.voice.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import java.net.URI;

public class ByocTrunkUpdater extends Updater<ByocTrunk> {

    private String pathSid;
    private String friendlyName;
    private URI voiceUrl;
    private HttpMethod voiceMethod;
    private URI voiceFallbackUrl;
    private HttpMethod voiceFallbackMethod;
    private URI statusCallbackUrl;
    private HttpMethod statusCallbackMethod;
    private Boolean cnamLookupEnabled;
    private String connectionPolicySid;
    private String fromDomainSid;

    public ByocTrunkUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    public ByocTrunkUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ByocTrunkUpdater setVoiceUrl(final URI voiceUrl) {
        this.voiceUrl = voiceUrl;
        return this;
    }

    public ByocTrunkUpdater setVoiceUrl(final String voiceUrl) {
        return setVoiceUrl(Promoter.uriFromString(voiceUrl));
    }

    public ByocTrunkUpdater setVoiceMethod(final HttpMethod voiceMethod) {
        this.voiceMethod = voiceMethod;
        return this;
    }

    public ByocTrunkUpdater setVoiceFallbackUrl(final URI voiceFallbackUrl) {
        this.voiceFallbackUrl = voiceFallbackUrl;
        return this;
    }

    public ByocTrunkUpdater setVoiceFallbackUrl(final String voiceFallbackUrl) {
        return setVoiceFallbackUrl(Promoter.uriFromString(voiceFallbackUrl));
    }

    public ByocTrunkUpdater setVoiceFallbackMethod(
        final HttpMethod voiceFallbackMethod
    ) {
        this.voiceFallbackMethod = voiceFallbackMethod;
        return this;
    }

    public ByocTrunkUpdater setStatusCallbackUrl(final URI statusCallbackUrl) {
        this.statusCallbackUrl = statusCallbackUrl;
        return this;
    }

    public ByocTrunkUpdater setStatusCallbackUrl(
        final String statusCallbackUrl
    ) {
        return setStatusCallbackUrl(Promoter.uriFromString(statusCallbackUrl));
    }

    public ByocTrunkUpdater setStatusCallbackMethod(
        final HttpMethod statusCallbackMethod
    ) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public ByocTrunkUpdater setCnamLookupEnabled(
        final Boolean cnamLookupEnabled
    ) {
        this.cnamLookupEnabled = cnamLookupEnabled;
        return this;
    }

    public ByocTrunkUpdater setConnectionPolicySid(
        final String connectionPolicySid
    ) {
        this.connectionPolicySid = connectionPolicySid;
        return this;
    }

    public ByocTrunkUpdater setFromDomainSid(final String fromDomainSid) {
        this.fromDomainSid = fromDomainSid;
        return this;
    }

    @Override
    public ByocTrunk update(final TwilioRestClient client) {
        String path = "/v1/ByocTrunks/{Sid}";

        path = path.replace("{" + "Sid" + "}", this.pathSid.toString());

        Request request = new Request(
            HttpMethod.POST,
            Domains.VOICE.toString(),
            path
        );
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException(
                "ByocTrunk update failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return ByocTrunk.fromJson(
            response.getStream(),
            client.getObjectMapper()
        );
    }

    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }
        if (voiceUrl != null) {
            request.addPostParam("VoiceUrl", voiceUrl.toString());
        }
        if (voiceMethod != null) {
            request.addPostParam("VoiceMethod", voiceMethod.toString());
        }
        if (voiceFallbackUrl != null) {
            request.addPostParam(
                "VoiceFallbackUrl",
                voiceFallbackUrl.toString()
            );
        }
        if (voiceFallbackMethod != null) {
            request.addPostParam(
                "VoiceFallbackMethod",
                voiceFallbackMethod.toString()
            );
        }
        if (statusCallbackUrl != null) {
            request.addPostParam(
                "StatusCallbackUrl",
                statusCallbackUrl.toString()
            );
        }
        if (statusCallbackMethod != null) {
            request.addPostParam(
                "StatusCallbackMethod",
                statusCallbackMethod.toString()
            );
        }
        if (cnamLookupEnabled != null) {
            request.addPostParam(
                "CnamLookupEnabled",
                cnamLookupEnabled.toString()
            );
        }
        if (connectionPolicySid != null) {
            request.addPostParam("ConnectionPolicySid", connectionPolicySid);
        }
        if (fromDomainSid != null) {
            request.addPostParam("FromDomainSid", fromDomainSid);
        }
    }
}
