/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.fax;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

/**
 * TwiML wrapper for {@code <Receive>}
 */
@JsonDeserialize(builder = Receive.Builder.class)
public class Receive extends TwiML {
    public enum MediaType {
        APPLICATION_PDF("application/pdf"),
        IMAGE_TIFF("image/tiff");

        private final String value;

        private MediaType(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    public enum PageSize {
        LETTER("letter"),
        LEGAL("legal"),
        A4("a4");

        private final String value;

        private PageSize(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    private final URI action;
    private final HttpMethod method;
    private final Receive.MediaType mediaType;
    private final Receive.PageSize pageSize;
    private final Boolean storeMedia;

    /**
     * For XML Serialization/Deserialization
     */
    private Receive() {
        this(new Builder());
    }

    /**
     * Create a new {@code <Receive>} element
     */
    private Receive(Builder b) {
        super("Receive", b);
        this.action = b.action;
        this.method = b.method;
        this.mediaType = b.mediaType;
        this.pageSize = b.pageSize;
        this.storeMedia = b.storeMedia;
    }

    /**
     * Attributes to set on the generated XML element
     *
     * @return A Map of attribute keys to values
     */
    protected Map<String, String> getElementAttributes() {
        // Preserve order of attributes
        Map<String, String> attrs = new HashMap<>();

        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getMediaType() != null) {
            attrs.put("mediaType", this.getMediaType().toString());
        }
        if (this.getPageSize() != null) {
            attrs.put("pageSize", this.getPageSize().toString());
        }
        if (this.isStoreMedia() != null) {
            attrs.put("storeMedia", this.isStoreMedia().toString());
        }

        return attrs;
    }

    /**
     * Receive action URL
     *
     * @return Receive action URL
     */
    public URI getAction() {
        return action;
    }

    /**
     * Receive action URL method
     *
     * @return Receive action URL method
     */
    public HttpMethod getMethod() {
        return method;
    }

    /**
     * The media type used to store media in the fax media store
     *
     * @return The media type used to store media in the fax media store
     */
    public Receive.MediaType getMediaType() {
        return mediaType;
    }

    /**
     * What size to interpret received pages as
     *
     * @return What size to interpret received pages as
     */
    public Receive.PageSize getPageSize() {
        return pageSize;
    }

    /**
     * Whether or not to store received media in the fax media store
     *
     * @return Whether or not to store received media in the fax media store
     */
    public Boolean isStoreMedia() {
        return storeMedia;
    }

    /**
     * Create a new {@code <Receive>} element
     */
    @JsonPOJOBuilder(withPrefix = "")
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <Receive.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a Receive.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private URI action;
        private HttpMethod method;
        private Receive.MediaType mediaType;
        private Receive.PageSize pageSize;
        private Boolean storeMedia;

        /**
         * Receive action URL
         */
        @JacksonXmlProperty(isAttribute = true, localName = "action")
        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        /**
         * Receive action URL
         */
        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        /**
         * Receive action URL method
         */
        @JacksonXmlProperty(isAttribute = true, localName = "method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * The media type used to store media in the fax media store
         */
        @JacksonXmlProperty(isAttribute = true, localName = "mediaType")
        public Builder mediaType(Receive.MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        /**
         * What size to interpret received pages as
         */
        @JacksonXmlProperty(isAttribute = true, localName = "pageSize")
        public Builder pageSize(Receive.PageSize pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        /**
         * Whether or not to store received media in the fax media store
         */
        @JacksonXmlProperty(isAttribute = true, localName = "storeMedia")
        public Builder storeMedia(Boolean storeMedia) {
            this.storeMedia = storeMedia;
            return this;
        }

        /**
         * Create and return resulting {@code <Receive>} element
         */
        public Receive build() {
            return new Receive(this);
        }
    }
}