/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.messaging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

/**
 * TwiML wrapper for {@code <Body>}
 */
@JsonDeserialize(builder = Body.Builder.class)
public class Body extends TwiML {
    private final String message;

    /**
     * For XML Serialization/Deserialization
     */
    private Body() {
        this(new Builder((String) null));
    }

    /**
     * Create a new {@code <Body>} element
     */
    private Body(Builder b) {
        super("Body", b);
        this.message = b.message;
    }

    /**
     * The body of the TwiML element
     *
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getMessage() == null ? null : this.getMessage();
    }

    /**
     * Message Body
     *
     * @return Message Body
     */
    public String getMessage() {
        return message;
    }

    /**
     * Create a new {@code <Body>} element
     */
    @JsonPOJOBuilder(withPrefix = "")
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <Body.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a Body.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private String message;

        /**
         * Create a {@code <Body>} with message
         */
        public Builder(String message) {
            this.message = message;
        }

        /**
         * Create a {@code <Body>} (for XML deserialization)
         */
        private Builder() {
        }

        /**
         * Create and return resulting {@code <Body>} element
         */
        public Body build() {
            return new Body(this);
        }
    }
}