/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * TwiML wrapper for {@code <Application>}
 */
@JsonDeserialize(builder = Application.Builder.class)
public class Application extends TwiML {
    public enum Event {
        INITIATED("initiated"),
        RINGING("ringing"),
        ANSWERED("answered"),
        COMPLETED("completed");

        private final String value;

        private Event(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    private final URI url;
    private final HttpMethod method;
    private final List<Application.Event> statusCallbackEvent;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final String customerId;
    private final Boolean copyParentTo;
    private final String applicationSid;

    /**
     * For XML Serialization/Deserialization
     */
    private Application() {
        this(new Builder());
    }

    /**
     * Create a new {@code <Application>} element
     */
    private Application(Builder b) {
        super("Application", b);
        this.url = b.url;
        this.method = b.method;
        this.statusCallbackEvent = b.statusCallbackEvent;
        this.statusCallback = b.statusCallback;
        this.statusCallbackMethod = b.statusCallbackMethod;
        this.customerId = b.customerId;
        this.copyParentTo = b.copyParentTo;
        this.applicationSid = b.applicationSid;
    }

    /**
     * The body of the TwiML element
     *
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getApplicationSid() == null ? null : this.getApplicationSid();
    }

    /**
     * Attributes to set on the generated XML element
     *
     * @return A Map of attribute keys to values
     */
    protected Map<String, String> getElementAttributes() {
        // Preserve order of attributes
        Map<String, String> attrs = new HashMap<>();

        if (this.getUrl() != null) {
            attrs.put("url", this.getUrl().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getStatusCallbackEvents() != null) {
            attrs.put("statusCallbackEvent", this.getStatusCallbackEventsAsString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback().toString());
        }
        if (this.getStatusCallbackMethod() != null) {
            attrs.put("statusCallbackMethod", this.getStatusCallbackMethod().toString());
        }
        if (this.getCustomerId() != null) {
            attrs.put("customerId", this.getCustomerId());
        }
        if (this.isCopyParentTo() != null) {
            attrs.put("copyParentTo", this.isCopyParentTo().toString());
        }

        return attrs;
    }

    /**
     * TwiML URL
     *
     * @return TwiML URL
     */
    public URI getUrl() {
        return url;
    }

    /**
     * TwiML URL Method
     *
     * @return TwiML URL Method
     */
    public HttpMethod getMethod() {
        return method;
    }

    /**
     * Events to trigger status callback
     *
     * @return Events to trigger status callback
     */
    public List<Application.Event> getStatusCallbackEvents() {
        return statusCallbackEvent;
    }

    protected String getStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Application.Event> iter = this.getStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (iter.hasNext()) {
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    /**
     * Status Callback URL
     *
     * @return Status Callback URL
     */
    public URI getStatusCallback() {
        return statusCallback;
    }

    /**
     * Status Callback URL Method
     *
     * @return Status Callback URL Method
     */
    public HttpMethod getStatusCallbackMethod() {
        return statusCallbackMethod;
    }

    /**
     * Identity of the customer calling application
     *
     * @return Identity of the customer calling application
     */
    public String getCustomerId() {
        return customerId;
    }

    /**
     * Copy parent call To field to called application side, otherwise use the
     * application sid as To field
     *
     * @return Copy parent call To field to called application side, otherwise use
     *         the application sid as To field
     */
    public Boolean isCopyParentTo() {
        return copyParentTo;
    }

    /**
     * Application sid
     *
     * @return Application sid
     */
    public String getApplicationSid() {
        return applicationSid;
    }

    /**
     * Create a new {@code <Application>} element
     */
    @JsonPOJOBuilder(withPrefix = "")
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <Application.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a Application.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private URI url;
        private HttpMethod method;
        private List<Application.Event> statusCallbackEvent;
        private URI statusCallback;
        private HttpMethod statusCallbackMethod;
        private String customerId;
        private Boolean copyParentTo;
        private String applicationSid;

        /**
         * Create a {@code <Application>} with applicationSid
         */
        public Builder(String applicationSid) {
            this.applicationSid = applicationSid;
        }

        /**
         * Create a {@code <Application>} with child elements
         */
        public Builder() {
        }

        /**
         * TwiML URL
         */
        @JacksonXmlProperty(isAttribute = true, localName = "url")
        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        /**
         * TwiML URL
         */
        public Builder url(String url) {
            this.url = Promoter.uriFromString(url);
            return this;
        }

        /**
         * TwiML URL Method
         */
        @JacksonXmlProperty(isAttribute = true, localName = "method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Events to trigger status callback
         */
        @JacksonXmlProperty(isAttribute = true, localName = "statusCallbackEvent")
        public Builder statusCallbackEvents(List<Application.Event> statusCallbackEvent) {
            this.statusCallbackEvent = statusCallbackEvent;
            return this;
        }

        /**
         * Events to trigger status callback
         */
        public Builder statusCallbackEvents(Application.Event statusCallbackEvent) {
            this.statusCallbackEvent = Promoter.listOfOne(statusCallbackEvent);
            return this;
        }

        /**
         * Status Callback URL
         */
        @JacksonXmlProperty(isAttribute = true, localName = "statusCallback")
        public Builder statusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        /**
         * Status Callback URL
         */
        public Builder statusCallback(String statusCallback) {
            this.statusCallback = Promoter.uriFromString(statusCallback);
            return this;
        }

        /**
         * Status Callback URL Method
         */
        @JacksonXmlProperty(isAttribute = true, localName = "statusCallbackMethod")
        public Builder statusCallbackMethod(HttpMethod statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        /**
         * Identity of the customer calling application
         */
        @JacksonXmlProperty(isAttribute = true, localName = "customerId")
        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        /**
         * Copy parent call To field to called application side, otherwise use the
         * application sid as To field
         */
        @JacksonXmlProperty(isAttribute = true, localName = "copyParentTo")
        public Builder copyParentTo(Boolean copyParentTo) {
            this.copyParentTo = copyParentTo;
            return this;
        }

        /**
         * Application sid
         */
        @JacksonXmlProperty(isAttribute = true, localName = "applicationSid")
        public Builder applicationSid(String applicationSid) {
            this.applicationSid = applicationSid;
            return this;
        }

        /**
         * Add a child {@code <ApplicationSid>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "ApplicationSid")
        public Builder applicationSid(ApplicationSid applicationSid) {
            this.children.add(applicationSid);
            return this;
        }

        /**
         * Add a child {@code <Parameter>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "Parameter")
        public Builder parameter(Parameter parameter) {
            this.children.add(parameter);
            return this;
        }

        /**
         * Create and return resulting {@code <Application>} element
         */
        public Application build() {
            return new Application(this);
        }
    }
}