/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

/**
 * TwiML wrapper for {@code <ApplicationSid>}
 */
@JsonDeserialize(builder = ApplicationSid.Builder.class)
public class ApplicationSid extends TwiML {
    private final String sid;

    /**
     * For XML Serialization/Deserialization
     */
    private ApplicationSid() {
        this(new Builder((String) null));
    }

    /**
     * Create a new {@code <ApplicationSid>} element
     */
    private ApplicationSid(Builder b) {
        super("ApplicationSid", b);
        this.sid = b.sid;
    }

    /**
     * The body of the TwiML element
     *
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getSid() == null ? null : this.getSid();
    }

    /**
     * Application sid to dial
     *
     * @return Application sid to dial
     */
    public String getSid() {
        return sid;
    }

    /**
     * Create a new {@code <ApplicationSid>} element
     */
    @JsonPOJOBuilder(withPrefix = "")
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <ApplicationSid.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a ApplicationSid.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private String sid;

        /**
         * Create a {@code <ApplicationSid>} with sid
         */
        public Builder(String sid) {
            this.sid = sid;
        }

        /**
         * Create a {@code <ApplicationSid>} (for XML deserialization)
         */
        private Builder() {
        }

        /**
         * Create and return resulting {@code <ApplicationSid>} element
         */
        public ApplicationSid build() {
            return new ApplicationSid(this);
        }
    }
}