/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * TwiML wrapper for {@code <Conversation>}
 */
@JsonDeserialize(builder = Conversation.Builder.class)
public class Conversation extends TwiML {
    public enum Record {
        DO_NOT_RECORD("do-not-record"),
        RECORD_FROM_ANSWER("record-from-answer"),
        RECORD_FROM_RINGING("record-from-ringing"),
        RECORD_FROM_ANSWER_DUAL("record-from-answer-dual"),
        RECORD_FROM_RINGING_DUAL("record-from-ringing-dual"),
        TRUE("true"),
        FALSE("false");

        private final String value;

        private Record(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    public enum Trim {
        TRIM_SILENCE("trim-silence"),
        DO_NOT_TRIM("do-not-trim");

        private final String value;

        private Trim(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    public enum RecordingEvent {
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        ABSENT("absent");

        private final String value;

        private RecordingEvent(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    public enum Event {
        CALL_INITIATED("call-initiated"),
        CALL_RINGING("call-ringing"),
        CALL_ANSWERED("call-answered"),
        CALL_COMPLETED("call-completed");

        private final String value;

        private Event(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    private final String serviceInstanceSid;
    private final Boolean inboundAutocreation;
    private final Integer routingAssignmentTimeout;
    private final Integer inboundTimeout;
    private final URI url;
    private final HttpMethod method;
    private final Conversation.Record record;
    private final Conversation.Trim trim;
    private final URI recordingStatusCallback;
    private final HttpMethod recordingStatusCallbackMethod;
    private final List<Conversation.RecordingEvent> recordingStatusCallbackEvent;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final List<Conversation.Event> statusCallbackEvent;

    /**
     * For XML Serialization/Deserialization
     */
    private Conversation() {
        this(new Builder());
    }

    /**
     * Create a new {@code <Conversation>} element
     */
    private Conversation(Builder b) {
        super("Conversation", b);
        this.serviceInstanceSid = b.serviceInstanceSid;
        this.inboundAutocreation = b.inboundAutocreation;
        this.routingAssignmentTimeout = b.routingAssignmentTimeout;
        this.inboundTimeout = b.inboundTimeout;
        this.url = b.url;
        this.method = b.method;
        this.record = b.record;
        this.trim = b.trim;
        this.recordingStatusCallback = b.recordingStatusCallback;
        this.recordingStatusCallbackMethod = b.recordingStatusCallbackMethod;
        this.recordingStatusCallbackEvent = b.recordingStatusCallbackEvent;
        this.statusCallback = b.statusCallback;
        this.statusCallbackMethod = b.statusCallbackMethod;
        this.statusCallbackEvent = b.statusCallbackEvent;
    }

    /**
     * Attributes to set on the generated XML element
     *
     * @return A Map of attribute keys to values
     */
    protected Map<String, String> getElementAttributes() {
        // Preserve order of attributes
        Map<String, String> attrs = new HashMap<>();

        if (this.getServiceInstanceSid() != null) {
            attrs.put("serviceInstanceSid", this.getServiceInstanceSid());
        }
        if (this.isInboundAutocreation() != null) {
            attrs.put("inboundAutocreation", this.isInboundAutocreation().toString());
        }
        if (this.getRoutingAssignmentTimeout() != null) {
            attrs.put("routingAssignmentTimeout", this.getRoutingAssignmentTimeout().toString());
        }
        if (this.getInboundTimeout() != null) {
            attrs.put("inboundTimeout", this.getInboundTimeout().toString());
        }
        if (this.getUrl() != null) {
            attrs.put("url", this.getUrl().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getRecord() != null) {
            attrs.put("record", this.getRecord().toString());
        }
        if (this.getTrim() != null) {
            attrs.put("trim", this.getTrim().toString());
        }
        if (this.getRecordingStatusCallback() != null) {
            attrs.put("recordingStatusCallback", this.getRecordingStatusCallback().toString());
        }
        if (this.getRecordingStatusCallbackMethod() != null) {
            attrs.put("recordingStatusCallbackMethod", this.getRecordingStatusCallbackMethod().toString());
        }
        if (this.getRecordingStatusCallbackEvents() != null) {
            attrs.put("recordingStatusCallbackEvent", this.getRecordingStatusCallbackEventsAsString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback().toString());
        }
        if (this.getStatusCallbackMethod() != null) {
            attrs.put("statusCallbackMethod", this.getStatusCallbackMethod().toString());
        }
        if (this.getStatusCallbackEvents() != null) {
            attrs.put("statusCallbackEvent", this.getStatusCallbackEventsAsString());
        }

        return attrs;
    }

    /**
     * Service instance Sid
     *
     * @return Service instance Sid
     */
    public String getServiceInstanceSid() {
        return serviceInstanceSid;
    }

    /**
     * Inbound autocreation
     *
     * @return Inbound autocreation
     */
    public Boolean isInboundAutocreation() {
        return inboundAutocreation;
    }

    /**
     * Routing assignment timeout
     *
     * @return Routing assignment timeout
     */
    public Integer getRoutingAssignmentTimeout() {
        return routingAssignmentTimeout;
    }

    /**
     * Inbound timeout
     *
     * @return Inbound timeout
     */
    public Integer getInboundTimeout() {
        return inboundTimeout;
    }

    /**
     * TwiML URL
     *
     * @return TwiML URL
     */
    public URI getUrl() {
        return url;
    }

    /**
     * TwiML URL method
     *
     * @return TwiML URL method
     */
    public HttpMethod getMethod() {
        return method;
    }

    /**
     * Record
     *
     * @return Record
     */
    public Conversation.Record getRecord() {
        return record;
    }

    /**
     * Trim
     *
     * @return Trim
     */
    public Conversation.Trim getTrim() {
        return trim;
    }

    /**
     * Recording status callback URL
     *
     * @return Recording status callback URL
     */
    public URI getRecordingStatusCallback() {
        return recordingStatusCallback;
    }

    /**
     * Recording status callback URL method
     *
     * @return Recording status callback URL method
     */
    public HttpMethod getRecordingStatusCallbackMethod() {
        return recordingStatusCallbackMethod;
    }

    /**
     * Recording status callback events
     *
     * @return Recording status callback events
     */
    public List<Conversation.RecordingEvent> getRecordingStatusCallbackEvents() {
        return recordingStatusCallbackEvent;
    }

    protected String getRecordingStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Conversation.RecordingEvent> iter = this.getRecordingStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (iter.hasNext()) {
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    /**
     * Status callback URL
     *
     * @return Status callback URL
     */
    public URI getStatusCallback() {
        return statusCallback;
    }

    /**
     * Status callback URL method
     *
     * @return Status callback URL method
     */
    public HttpMethod getStatusCallbackMethod() {
        return statusCallbackMethod;
    }

    /**
     * Events to call status callback URL
     *
     * @return Events to call status callback URL
     */
    public List<Conversation.Event> getStatusCallbackEvents() {
        return statusCallbackEvent;
    }

    protected String getStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Conversation.Event> iter = this.getStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (iter.hasNext()) {
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    /**
     * Create a new {@code <Conversation>} element
     */
    @JsonPOJOBuilder(withPrefix = "")
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <Conversation.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a Conversation.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private String serviceInstanceSid;
        private Boolean inboundAutocreation;
        private Integer routingAssignmentTimeout;
        private Integer inboundTimeout;
        private URI url;
        private HttpMethod method;
        private Conversation.Record record;
        private Conversation.Trim trim;
        private URI recordingStatusCallback;
        private HttpMethod recordingStatusCallbackMethod;
        private List<Conversation.RecordingEvent> recordingStatusCallbackEvent;
        private URI statusCallback;
        private HttpMethod statusCallbackMethod;
        private List<Conversation.Event> statusCallbackEvent;

        /**
         * Service instance Sid
         */
        @JacksonXmlProperty(isAttribute = true, localName = "serviceInstanceSid")
        public Builder serviceInstanceSid(String serviceInstanceSid) {
            this.serviceInstanceSid = serviceInstanceSid;
            return this;
        }

        /**
         * Inbound autocreation
         */
        @JacksonXmlProperty(isAttribute = true, localName = "inboundAutocreation")
        public Builder inboundAutocreation(Boolean inboundAutocreation) {
            this.inboundAutocreation = inboundAutocreation;
            return this;
        }

        /**
         * Routing assignment timeout
         */
        @JacksonXmlProperty(isAttribute = true, localName = "routingAssignmentTimeout")
        public Builder routingAssignmentTimeout(Integer routingAssignmentTimeout) {
            this.routingAssignmentTimeout = routingAssignmentTimeout;
            return this;
        }

        /**
         * Inbound timeout
         */
        @JacksonXmlProperty(isAttribute = true, localName = "inboundTimeout")
        public Builder inboundTimeout(Integer inboundTimeout) {
            this.inboundTimeout = inboundTimeout;
            return this;
        }

        /**
         * TwiML URL
         */
        @JacksonXmlProperty(isAttribute = true, localName = "url")
        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        /**
         * TwiML URL
         */
        public Builder url(String url) {
            this.url = Promoter.uriFromString(url);
            return this;
        }

        /**
         * TwiML URL method
         */
        @JacksonXmlProperty(isAttribute = true, localName = "method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Record
         */
        @JacksonXmlProperty(isAttribute = true, localName = "record")
        public Builder record(Conversation.Record record) {
            this.record = record;
            return this;
        }

        /**
         * Trim
         */
        @JacksonXmlProperty(isAttribute = true, localName = "trim")
        public Builder trim(Conversation.Trim trim) {
            this.trim = trim;
            return this;
        }

        /**
         * Recording status callback URL
         */
        @JacksonXmlProperty(isAttribute = true, localName = "recordingStatusCallback")
        public Builder recordingStatusCallback(URI recordingStatusCallback) {
            this.recordingStatusCallback = recordingStatusCallback;
            return this;
        }

        /**
         * Recording status callback URL
         */
        public Builder recordingStatusCallback(String recordingStatusCallback) {
            this.recordingStatusCallback = Promoter.uriFromString(recordingStatusCallback);
            return this;
        }

        /**
         * Recording status callback URL method
         */
        @JacksonXmlProperty(isAttribute = true, localName = "recordingStatusCallbackMethod")
        public Builder recordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
            this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
            return this;
        }

        /**
         * Recording status callback events
         */
        @JacksonXmlProperty(isAttribute = true, localName = "recordingStatusCallbackEvent")
        public Builder recordingStatusCallbackEvents(List<Conversation.RecordingEvent> recordingStatusCallbackEvent) {
            this.recordingStatusCallbackEvent = recordingStatusCallbackEvent;
            return this;
        }

        /**
         * Recording status callback events
         */
        public Builder recordingStatusCallbackEvents(Conversation.RecordingEvent recordingStatusCallbackEvent) {
            this.recordingStatusCallbackEvent = Promoter.listOfOne(recordingStatusCallbackEvent);
            return this;
        }

        /**
         * Status callback URL
         */
        @JacksonXmlProperty(isAttribute = true, localName = "statusCallback")
        public Builder statusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        /**
         * Status callback URL
         */
        public Builder statusCallback(String statusCallback) {
            this.statusCallback = Promoter.uriFromString(statusCallback);
            return this;
        }

        /**
         * Status callback URL method
         */
        @JacksonXmlProperty(isAttribute = true, localName = "statusCallbackMethod")
        public Builder statusCallbackMethod(HttpMethod statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        /**
         * Events to call status callback URL
         */
        @JacksonXmlProperty(isAttribute = true, localName = "statusCallbackEvent")
        public Builder statusCallbackEvents(List<Conversation.Event> statusCallbackEvent) {
            this.statusCallbackEvent = statusCallbackEvent;
            return this;
        }

        /**
         * Events to call status callback URL
         */
        public Builder statusCallbackEvents(Conversation.Event statusCallbackEvent) {
            this.statusCallbackEvent = Promoter.listOfOne(statusCallbackEvent);
            return this;
        }

        /**
         * Create and return resulting {@code <Conversation>} element
         */
        public Conversation build() {
            return new Conversation(this);
        }
    }
}