/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

/**
 * TwiML wrapper for {@code <Identity>}
 */
@JsonDeserialize(builder = Identity.Builder.class)
public class Identity extends TwiML {
    private final String clientIdentity;

    /**
     * For XML Serialization/Deserialization
     */
    private Identity() {
        this(new Builder((String) null));
    }

    /**
     * Create a new {@code <Identity>} element
     */
    private Identity(Builder b) {
        super("Identity", b);
        this.clientIdentity = b.clientIdentity;
    }

    /**
     * The body of the TwiML element
     *
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getClientIdentity() == null ? null : this.getClientIdentity();
    }

    /**
     * Identity of the client to dial
     *
     * @return Identity of the client to dial
     */
    public String getClientIdentity() {
        return clientIdentity;
    }

    /**
     * Create a new {@code <Identity>} element
     */
    @JsonPOJOBuilder(withPrefix = "")
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <Identity.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a Identity.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private String clientIdentity;

        /**
         * Create a {@code <Identity>} with clientIdentity
         */
        public Builder(String clientIdentity) {
            this.clientIdentity = clientIdentity;
        }

        /**
         * Create a {@code <Identity>} (for XML deserialization)
         */
        private Builder() {
        }

        /**
         * Create and return resulting {@code <Identity>} element
         */
        public Identity build() {
            return new Identity(this);
        }
    }
}