/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

import java.util.HashMap;
import java.util.Map;

/**
 * TwiML wrapper for {@code <sub>}
 */
@JsonDeserialize(builder = SsmlSub.Builder.class)
public class SsmlSub extends TwiML {
    private final String alias;
    private final String words;

    /**
     * For XML Serialization/Deserialization
     */
    private SsmlSub() {
        this(new Builder((String) null));
    }

    /**
     * Create a new {@code <sub>} element
     */
    private SsmlSub(Builder b) {
        super("sub", b);
        this.alias = b.alias;
        this.words = b.words;
    }

    /**
     * The body of the TwiML element
     *
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getWords() == null ? null : this.getWords();
    }

    /**
     * Attributes to set on the generated XML element
     *
     * @return A Map of attribute keys to values
     */
    protected Map<String, String> getElementAttributes() {
        // Preserve order of attributes
        Map<String, String> attrs = new HashMap<>();

        if (this.getAlias() != null) {
            attrs.put("alias", this.getAlias());
        }

        return attrs;
    }

    /**
     * Substitute a different word (or pronunciation) for selected text such as an
     * acronym or abbreviation
     *
     * @return Substitute a different word (or pronunciation) for selected text
     *         such as an acronym or abbreviation
     */
    public String getAlias() {
        return alias;
    }

    /**
     * Words to be substituted
     *
     * @return Words to be substituted
     */
    public String getWords() {
        return words;
    }

    /**
     * Create a new {@code <sub>} element
     */
    @JsonPOJOBuilder(withPrefix = "")
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <SsmlSub.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a SsmlSub.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private String alias;
        private String words;

        /**
         * Create a {@code <sub>} with words
         */
        public Builder(String words) {
            this.words = words;
        }

        /**
         * Create a {@code <sub>} (for XML deserialization)
         */
        private Builder() {
        }

        /**
         * Substitute a different word (or pronunciation) for selected text such as an
         * acronym or abbreviation
         */
        @JacksonXmlProperty(isAttribute = true, localName = "alias")
        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        /**
         * Create and return resulting {@code <sub>} element
         */
        public SsmlSub build() {
            return new SsmlSub(this);
        }
    }
}