/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.examples;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.factory.CallFactory;
import com.twilio.sdk.resource.factory.SmsFactory;
import com.twilio.sdk.resource.instance.Account;
import com.twilio.sdk.resource.instance.AvailablePhoneNumber;
import com.twilio.sdk.resource.instance.Call;
import com.twilio.sdk.resource.instance.Conference;
import com.twilio.sdk.resource.instance.Participant;
import com.twilio.sdk.resource.list.AccountList;
import com.twilio.sdk.resource.list.AvailablePhoneNumberList;
import com.twilio.sdk.resource.list.ParticipantList;
import java.util.HashMap;
import java.util.List;

public class RestExamples {
    public static final String ACCOUNT_SID = "AC123";
    public static final String AUTH_TOKEN = "456bef";

    public static void main(String[] args) throws TwilioRestException {
        TwilioRestClient client = new TwilioRestClient(ACCOUNT_SID, AUTH_TOKEN);
        Account mainAccount = client.getAccount();
        AccountList accountList = client.getAccounts();
        for (Account a : accountList) {
            System.out.println(a.getFriendlyName());
        }
        for (Account a : accountList) {
            System.out.println(a.getFriendlyName());
        }
        accountList = client.getAccounts();
        List accounts = accountList.getPageData();
        CallFactory callFactory = mainAccount.getCallFactory();
        HashMap<String, String> callParams = new HashMap<String, String>();
        callParams.put("To", "5105551212");
        callParams.put("From", "(510) 555-1212");
        callParams.put("Url", "http://demo.twilio.com/welcome/voice/");
        Call call = callFactory.create(callParams);
        System.out.println(call.getSid());
        SmsFactory smsFactory = mainAccount.getSmsFactory();
        HashMap<String, String> smsParams = new HashMap<String, String>();
        smsParams.put("To", "5105551212");
        smsParams.put("From", "(510) 555-1212");
        smsParams.put("Body", "This is a test message!");
        smsFactory.create(smsParams);
        AvailablePhoneNumberList phoneNumbers = mainAccount.getAvailablePhoneNumbers();
        List list = phoneNumbers.getPageData();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PhoneNumber", ((AvailablePhoneNumber)list.get(0)).getPhoneNumber());
        params.put("VoiceUrl", "http://demo.twilio.com/welcome/voice/");
        mainAccount.getIncomingPhoneNumberFactory().create(params);
        Conference c = mainAccount.getConference("CA12345...");
        ParticipantList participants = c.getParticipants();
        for (Participant p : participants) {
            if (Math.random() > 0.5) {
                p.mute();
                continue;
            }
            p.kick();
        }
        TwilioRestResponse resp = client.request("/2010-04-01/Accounts", "GET", null);
        if (!resp.isError()) {
            System.out.println(resp.getResponseText());
        }
    }
}

