/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.Resource;
import java.util.HashMap;
import java.util.Map;

public abstract class InstanceResource
extends Resource {
    private Map<String, Object> properties;

    public InstanceResource(TwilioRestClient client) {
        super(client);
        this.properties = new HashMap<String, Object>();
    }

    public InstanceResource(TwilioRestClient client, Map<String, Object> properties) {
        super(client);
        this.properties = new HashMap<String, Object>(properties);
        this.setLoaded(true);
    }

    public String getProperty(String name) {
        Object prop = this.properties.get(name);
        if (prop == null && !this.isLoaded()) {
            try {
                this.load(new HashMap<String, String>());
            }
            catch (TwilioRestException e) {
                throw new RuntimeException(e);
            }
        }
        if ((prop = this.properties.get(name)) == null) {
            return null;
        }
        if (prop instanceof String) {
            return (String)prop;
        }
        throw new IllegalArgumentException("Property " + name + " is an object.  Use getObject() instead.");
    }

    protected Object getObject(String name) {
        Object prop = this.properties.get(name);
        if (prop == null) {
            throw new IllegalArgumentException("Property " + name + " does not exist");
        }
        return prop;
    }

    protected void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void update(Map<String, String> params) throws TwilioRestException {
        this.getClient().safeRequest(this.getResourceLocation(), "POST", params);
    }

    @Override
    protected void parseResponse(TwilioRestResponse response) {
        Map<String, Object> properties = response.toMap();
        this.properties = new HashMap<String, Object>(properties);
    }
}

