/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.InstanceResource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class ShortCode
extends InstanceResource {
    private static final String SID_PROPERTY = "sid";

    public ShortCode(TwilioRestClient client) {
        super(client);
    }

    public ShortCode(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a Recording can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
    }

    public ShortCode(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SMS/Shortcodes/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public Date getDateCreated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_created"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateUpdated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_updated"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getShortCode() {
        return this.getProperty("short_code");
    }

    public String getSmsApplicationSid() {
        return this.getProperty("sms_application_sid");
    }

    public String getApiVersion() {
        return this.getProperty("api_version");
    }

    public String getSmsUrl() {
        return this.getProperty("sms_url");
    }

    public String getSmsMethod() {
        return this.getProperty("sms_method");
    }

    public String getSmsFallbackUrl() {
        return this.getProperty("sms_fallback_url");
    }

    public String getSmsFallbackMethod() {
        return this.getProperty("sms_fallback_method");
    }
}

