/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.verbs;

import com.twilio.sdk.verbs.TwiMLException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;

public class Verb {
    protected String tag;
    protected String body;
    protected HashMap<String, String> attributes;
    protected ArrayList<Verb> children;
    protected ArrayList<String> allowedVerbs;
    public static final String V_CLIENT = "Client";
    public static final String V_CONFERENCE = "Conference";
    public static final String V_DIAL = "Dial";
    public static final String V_HANGUP = "Hangup";
    public static final String V_GATHER = "Gather";
    public static final String V_NUMBER = "Number";
    public static final String V_PAUSE = "Pause";
    public static final String V_PLAY = "Play";
    public static final String V_RECORD = "Record";
    public static final String V_REDIRECT = "Redirect";
    public static final String V_RESPONSE = "Response";
    public static final String V_SAY = "Say";
    public static final String V_QUEUE = "Queue";
    public static final String V_ENQUEUE = "Enqueue";
    public static final String V_LEAVE = "Leave";
    public static final String V_SMS = "Sms";

    public Verb(String tag, String body) {
        this.tag = tag;
        this.body = body;
        this.attributes = new HashMap();
        this.children = new ArrayList();
    }

    public Verb append(Verb verb) throws TwiMLException {
        if (this.allowedVerbs != null && this.allowedVerbs.contains(verb.getTag())) {
            this.children.add(verb);
            return verb;
        }
        throw new TwiMLException("This is not a supported verb");
    }

    public String toXML() {
        String xml = "<" + this.tag;
        for (String key : this.attributes.keySet()) {
            xml = xml + " " + key + "=\"" + this.attributes.get(key) + "\"";
        }
        xml = xml + ">";
        if (this.body != null) {
            xml = xml + this.body;
        }
        for (Verb child : this.children) {
            xml = xml + child.toXML();
        }
        xml = xml + "</" + this.tag + ">";
        return xml;
    }

    public String asURL() {
        try {
            return URLEncoder.encode(this.toXML(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void set(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getBody() {
        return this.body;
    }

    public String getTag() {
        return this.tag;
    }

    public ArrayList<Verb> getChildren() {
        return this.children;
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }
}

