/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import com.twilio.sdk.parser.JsonResponseParser;
import com.twilio.sdk.parser.ResponseParser;
import com.twilio.sdk.parser.XmlResponseParser;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TwilioRestResponse {
    private String responseText;
    private int httpStatus;
    private String url;
    private String queryString;
    private boolean error;
    private String contentType;

    public TwilioRestResponse(String url, String text, int status) {
        Pattern p = Pattern.compile("([^?]+)\\??(.*)");
        Matcher m = p.matcher(url);
        m.matches();
        this.url = m.group(1);
        this.queryString = m.group(2);
        this.responseText = text;
        this.httpStatus = status;
        this.error = status >= 400;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public void setResponseText(String responseText) {
        this.responseText = responseText;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isClientError() {
        return this.getHttpStatus() >= 400 && this.getHttpStatus() < 500;
    }

    public boolean isServerError() {
        return this.getHttpStatus() >= 500;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isJson() {
        return this.contentType.equalsIgnoreCase("application/json");
    }

    public boolean isXml() {
        return this.contentType.equalsIgnoreCase("text/xml") || this.contentType.equalsIgnoreCase("application/xml");
    }

    public ResponseParser getParser() {
        if (this.isJson()) {
            return new JsonResponseParser();
        }
        if (this.isXml()) {
            return new XmlResponseParser();
        }
        throw new UnsupportedOperationException(this.contentType + " not a supported content type");
    }

    public Map<String, Object> toMap() {
        ResponseParser parser = this.getParser();
        return parser.parse(this);
    }
}

