/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import java.util.Map;

public abstract class Resource {
    private TwilioRestClient client;
    private String requestAccountSid;
    protected Map<String, String> filters;
    private boolean loaded;

    public Resource(TwilioRestClient client) {
        this.client = client;
    }

    protected TwilioRestClient getClient() {
        return this.client;
    }

    protected void load(Map<String, String> params) throws TwilioRestException {
        String path = this.getResourceLocation();
        TwilioRestResponse response = this.getClient().safeRequest(path, "GET", params);
        this.parseResponse(response);
        this.loaded = true;
    }

    protected abstract void parseResponse(TwilioRestResponse var1);

    protected boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    protected String getRequestAccountSid() {
        return this.requestAccountSid;
    }

    public void setRequestAccountSid(String sid) {
        this.requestAccountSid = sid;
    }

    protected abstract String getResourceLocation();
}

