/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class TwilioUtils {
    protected String authToken;
    protected String accountSid;

    public TwilioUtils(String authToken, String accountSid) {
        this.authToken = authToken;
        this.accountSid = accountSid;
    }

    public boolean validateRequest(String expectedSignature, String url, Map<String, String> params) {
        SecretKeySpec signingKey = new SecretKeySpec(this.authToken.getBytes(), "HmacSHA1");
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            StringBuffer data = new StringBuffer(url);
            if (params != null) {
                ArrayList<String> sortedKeys = new ArrayList<String>(params.keySet());
                Collections.sort(sortedKeys);
                for (String s : sortedKeys) {
                    data.append(s);
                    String v = "";
                    if (params.get(s) != null) {
                        v = params.get(s);
                    }
                    data.append(v);
                }
            }
            byte[] rawHmac = mac.doFinal(data.toString().getBytes());
            String signature = new String(Base64.encodeBase64((byte[])rawHmac));
            return signature.equals(expectedSignature);
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        catch (InvalidKeyException e) {
            return false;
        }
    }
}

