/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.factory.ApplicationFactory;
import com.twilio.sdk.resource.factory.CallFactory;
import com.twilio.sdk.resource.factory.IncomingPhoneNumberFactory;
import com.twilio.sdk.resource.factory.OutgoingCallerIdFactory;
import com.twilio.sdk.resource.factory.QueueFactory;
import com.twilio.sdk.resource.factory.SmsFactory;
import com.twilio.sdk.resource.factory.UsageTriggerFactory;
import com.twilio.sdk.resource.instance.Application;
import com.twilio.sdk.resource.instance.AuthorizedConnectApp;
import com.twilio.sdk.resource.instance.Call;
import com.twilio.sdk.resource.instance.Conference;
import com.twilio.sdk.resource.instance.ConnectApp;
import com.twilio.sdk.resource.instance.IncomingPhoneNumber;
import com.twilio.sdk.resource.instance.Notification;
import com.twilio.sdk.resource.instance.OutgoingCallerId;
import com.twilio.sdk.resource.instance.Queue;
import com.twilio.sdk.resource.instance.Recording;
import com.twilio.sdk.resource.instance.Sandbox;
import com.twilio.sdk.resource.instance.ShortCode;
import com.twilio.sdk.resource.instance.Sms;
import com.twilio.sdk.resource.instance.Transcription;
import com.twilio.sdk.resource.instance.UsageTrigger;
import com.twilio.sdk.resource.list.ApplicationList;
import com.twilio.sdk.resource.list.AuthorizedConnectAppList;
import com.twilio.sdk.resource.list.AvailablePhoneNumberList;
import com.twilio.sdk.resource.list.CallList;
import com.twilio.sdk.resource.list.ConferenceList;
import com.twilio.sdk.resource.list.ConnectAppList;
import com.twilio.sdk.resource.list.IncomingPhoneNumberList;
import com.twilio.sdk.resource.list.NotificationList;
import com.twilio.sdk.resource.list.OutgoingCallerIdList;
import com.twilio.sdk.resource.list.QueueList;
import com.twilio.sdk.resource.list.RecordingList;
import com.twilio.sdk.resource.list.ShortCodeList;
import com.twilio.sdk.resource.list.SmsList;
import com.twilio.sdk.resource.list.TranscriptionList;
import com.twilio.sdk.resource.list.UsageRecordList;
import com.twilio.sdk.resource.list.UsageTriggerList;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Account
extends InstanceResource {
    private static final String DATE_UPDATED_PROPERTY = "date_updated";
    private static final String DATE_CREATED_PROPERTY = "date_created";
    private static final String STATUS_PROPERTY = "status";
    private static final String TYPE_PROPERTY = "type";
    private static final String FRIENDLY_NAME_PROPERTY = "friendly_name";
    private static final String ACCOUNT_SID_PROPERTY = "sid";
    private static final String AUTH_TOKEN_PROPERTY = "auth_token";

    public Account(TwilioRestClient client) {
        super(client);
    }

    public Account(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
        Object ac = properties.get(ACCOUNT_SID_PROPERTY);
        if (ac != null && ac instanceof String) {
            String accountSid = (String)ac;
            this.setRequestAccountSid(accountSid);
        }
    }

    public String getSid() {
        if (this.getRequestAccountSid() != null) {
            return this.getRequestAccountSid();
        }
        return this.getProperty(ACCOUNT_SID_PROPERTY);
    }

    public void setSid(String accountSid) {
        this.setRequestAccountSid(accountSid);
        this.setProperty(ACCOUNT_SID_PROPERTY, accountSid);
    }

    public String getAuthToken() {
        return this.getProperty(AUTH_TOKEN_PROPERTY);
    }

    public void setAuthToken(String authToken) {
        this.setProperty(AUTH_TOKEN_PROPERTY, authToken);
    }

    public String getFriendlyName() {
        return this.getProperty(FRIENDLY_NAME_PROPERTY);
    }

    public String getStatus() {
        return this.getProperty(STATUS_PROPERTY);
    }

    public String getType() {
        return this.getProperty(TYPE_PROPERTY);
    }

    public Date getDateCreated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty(DATE_CREATED_PROPERTY));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateUpdated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty(DATE_UPDATED_PROPERTY));
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + ".json";
    }

    public CallList getCalls() {
        return this.getCalls(new HashMap<String, String>());
    }

    public CallList getCalls(Map<String, String> filters) {
        CallList calls = new CallList(this.getClient(), filters);
        calls.setRequestAccountSid(this.getRequestAccountSid());
        return calls;
    }

    public Call getCall(String sid) {
        Call call = new Call(this.getClient(), sid);
        call.setRequestAccountSid(this.getRequestAccountSid());
        return call;
    }

    public CallFactory getCallFactory() {
        return this.getCalls();
    }

    public SmsList getSmsMessages() {
        return this.getSmsMessages(new HashMap<String, String>());
    }

    public SmsList getSmsMessages(Map<String, String> filters) {
        SmsList sms = new SmsList(this.getClient(), filters);
        sms.setRequestAccountSid(this.getRequestAccountSid());
        return sms;
    }

    public Sms getSms(String sid) {
        Sms sms = new Sms(this.getClient(), sid);
        sms.setRequestAccountSid(this.getRequestAccountSid());
        return sms;
    }

    public SmsFactory getSmsFactory() {
        return this.getSmsMessages();
    }

    public ApplicationList getApplications() {
        return this.getApplications(new HashMap<String, String>());
    }

    public ApplicationList getApplications(Map<String, String> filters) {
        ApplicationList list = new ApplicationList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Application getApplication(String sid) {
        Application app = new Application(this.getClient(), sid);
        app.setRequestAccountSid(this.getRequestAccountSid());
        return app;
    }

    public ApplicationFactory getApplicationFactory() {
        return this.getApplications();
    }

    public AvailablePhoneNumberList getAvailablePhoneNumbers() {
        return this.getAvailablePhoneNumbers(new HashMap<String, String>());
    }

    public AvailablePhoneNumberList getAvailablePhoneNumbers(Map<String, String> filters) {
        AvailablePhoneNumberList list = new AvailablePhoneNumberList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public AvailablePhoneNumberList getAvailablePhoneNumbers(Map<String, String> filters, String isoCountry, String type) {
        AvailablePhoneNumberList list = new AvailablePhoneNumberList(this.getClient(), filters, isoCountry, type);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public ConferenceList getConferences() {
        return this.getConferences(new HashMap<String, String>());
    }

    public ConferenceList getConferences(Map<String, String> filters) {
        ConferenceList list = new ConferenceList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Conference getConference(String sid) {
        Conference conf = new Conference(this.getClient(), sid);
        conf.setRequestAccountSid(this.getRequestAccountSid());
        return conf;
    }

    public QueueList getQueues() {
        QueueList list = new QueueList(this.getClient(), this.filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Queue getQueue(String sid) {
        Queue queue = new Queue(this.getClient(), sid);
        queue.setRequestAccountSid(this.getRequestAccountSid());
        return queue;
    }

    public QueueFactory getQueueFactory() {
        return this.getQueues();
    }

    public IncomingPhoneNumberList getIncomingPhoneNumbers() {
        return this.getIncomingPhoneNumbers(new HashMap<String, String>());
    }

    public IncomingPhoneNumberList getIncomingPhoneNumbers(Map<String, String> filters) {
        IncomingPhoneNumberList list = new IncomingPhoneNumberList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public IncomingPhoneNumber getIncomingPhoneNumber(String sid) {
        IncomingPhoneNumber pn = new IncomingPhoneNumber(this.getClient(), sid);
        pn.setRequestAccountSid(this.getRequestAccountSid());
        return pn;
    }

    public IncomingPhoneNumberFactory getIncomingPhoneNumberFactory() {
        return this.getIncomingPhoneNumbers();
    }

    public ShortCodeList getShortCodes() {
        return this.getShortCodes(new HashMap<String, String>());
    }

    public ShortCodeList getShortCodes(Map<String, String> filters) {
        ShortCodeList list = new ShortCodeList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public ShortCode getShortCode(String sid) {
        ShortCode sc = new ShortCode(this.getClient(), sid);
        sc.setRequestAccountSid(this.getRequestAccountSid());
        return sc;
    }

    public NotificationList getNotifications() {
        return this.getNotifications(new HashMap<String, String>());
    }

    public NotificationList getNotifications(Map<String, String> filters) {
        NotificationList list = new NotificationList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Notification getNotification(String sid) {
        Notification n = new Notification(this.getClient(), sid);
        n.setRequestAccountSid(this.getRequestAccountSid());
        return n;
    }

    public OutgoingCallerIdList getOutgoingCallerIds() {
        return this.getOutgoingCallerIds(new HashMap<String, String>());
    }

    public OutgoingCallerIdList getOutgoingCallerIds(Map<String, String> filters) {
        OutgoingCallerIdList list = new OutgoingCallerIdList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public OutgoingCallerId getOutgoingCallerId(String sid) {
        OutgoingCallerId number = new OutgoingCallerId(this.getClient(), sid);
        number.setRequestAccountSid(this.getRequestAccountSid());
        return number;
    }

    public OutgoingCallerIdFactory getOutgoingCallerIdFactory() {
        return this.getOutgoingCallerIds();
    }

    public RecordingList getRecordings() {
        return this.getRecordings(new HashMap<String, String>());
    }

    public RecordingList getRecordings(Map<String, String> filters) {
        RecordingList list = new RecordingList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Recording getRecording(String sid) {
        Recording r = new Recording(this.getClient(), sid);
        r.setRequestAccountSid(this.getRequestAccountSid());
        return r;
    }

    public TranscriptionList getTranscriptions() {
        return this.getTranscriptions(new HashMap<String, String>());
    }

    public TranscriptionList getTranscriptions(Map<String, String> filters) {
        TranscriptionList list = new TranscriptionList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Transcription getTranscription(String sid) {
        Transcription tr = new Transcription(this.getClient(), sid);
        tr.setRequestAccountSid(this.getRequestAccountSid());
        return tr;
    }

    public UsageRecordList getUsageRecords(Map<String, String> filters) {
        UsageRecordList list = new UsageRecordList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public UsageRecordList getUsageRecords() {
        return this.getUsageRecords(new HashMap<String, String>());
    }

    public UsageTrigger getUsageTrigger(String sid) {
        UsageTrigger trigger = new UsageTrigger(this.getClient(), sid);
        trigger.setRequestAccountSid(this.getRequestAccountSid());
        return trigger;
    }

    public UsageTriggerFactory getUsageTriggerFactory() {
        return this.getUsageTriggers();
    }

    public UsageTriggerList getUsageTriggers(Map<String, String> filters) {
        UsageTriggerList list = new UsageTriggerList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public UsageTriggerList getUsageTriggers() {
        return this.getUsageTriggers(new HashMap<String, String>());
    }

    public ConnectAppList getConnectApps() {
        return this.getConnectApps(new HashMap<String, String>());
    }

    public ConnectAppList getConnectApps(Map<String, String> filters) {
        ConnectAppList list = new ConnectAppList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public ConnectApp getConnectApp(String sid) {
        ConnectApp cn = new ConnectApp(this.getClient(), sid);
        cn.setRequestAccountSid(this.getRequestAccountSid());
        return cn;
    }

    public AuthorizedConnectAppList getAuthorizedConnectApps() {
        return this.getAuthorizedConnectApps(new HashMap<String, String>());
    }

    public AuthorizedConnectAppList getAuthorizedConnectApps(Map<String, String> filters) {
        AuthorizedConnectAppList list = new AuthorizedConnectAppList(this.getClient(), filters);
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public AuthorizedConnectApp getAuthorizedConnectApp(String sid) {
        AuthorizedConnectApp cn = new AuthorizedConnectApp(this.getClient(), sid);
        cn.setRequestAccountSid(this.getRequestAccountSid());
        return cn;
    }

    public Sandbox getSandbox() {
        Sandbox sb = new Sandbox(this.getClient());
        sb.setRequestAccountSid(this.getRequestAccountSid());
        return sb;
    }

    public boolean close() throws TwilioRestException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("Status", "closed");
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", vars);
        return !response.isError();
    }
}

