/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.instance.UsageCategory;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class UsageRecord
extends InstanceResource {
    private static final String SID_PROPERTY = "sid";

    public UsageRecord(TwilioRestClient client) {
        super(client);
    }

    @Override
    protected String getResourceLocation() {
        return null;
    }

    public UsageRecord(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a UsageRecord can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
    }

    public UsageRecord(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public UsageCategory getCategory() {
        return UsageCategory.valueOf(this.getProperty("Category").replace('-', '_'));
    }

    public String getDescription() {
        return this.getProperty("Description");
    }

    public Date getStartDate() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("StartDate"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getEndDate() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("EndDate"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public BigDecimal getUsage() {
        return new BigDecimal(this.getProperty("Usage"));
    }

    public String getUsageUnits() {
        return this.getProperty("UsageUnits");
    }

    public Long getCount() {
        String count = this.getProperty("Count");
        return count == null ? null : Long.valueOf(Long.parseLong(this.getProperty("Count")));
    }

    public String getCountUnits() {
        return this.getProperty("CountUnits");
    }

    public BigDecimal getPrice() {
        return new BigDecimal(this.getProperty("Price"));
    }

    public String getPriceUnit() {
        return this.getProperty("PriceUnit");
    }

    public String getUri() {
        return this.getProperty("Uri");
    }

    public String[] getSubresourceUris() {
        return null;
    }
}

