/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.sip;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class Credential
extends InstanceResource {
    private static final String SID_PROPERTY = "sid";
    private String requestCredentialListSid;

    public Credential(TwilioRestClient client) {
        super(client);
    }

    public Credential(TwilioRestClient client, String credentialListSid, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a Credential can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
        this.requestCredentialListSid = credentialListSid;
    }

    public Credential(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SIP/CredentialLists/" + this.getRequestCredentialListSid() + "/Credentials/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public Date getDateCreated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_created"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateUpdated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_updated"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getUsername() {
        return this.getProperty("username");
    }

    public String getRequestCredentialListSid() {
        return this.requestCredentialListSid;
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

