/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONValue;

public class TwilioCapability {
    private String accountSid;
    private String authToken;
    private List<String> scopes;
    private boolean buildIncomingScope = false;
    private String incomingClientName = null;
    private boolean buildOutgoingScope = false;
    private String appSid = null;
    private String outgoingClientName = null;
    private Map<String, String> outgoingParams = null;

    public TwilioCapability(String accountSid, String authToken) {
        this.accountSid = accountSid;
        this.authToken = authToken;
        this.scopes = new ArrayList<String>();
    }

    private String buildScopeString(String serivce, String priviledge, Map<String, String> params) {
        StringBuilder scope = new StringBuilder();
        scope.append("scope:");
        scope.append(serivce);
        scope.append(":");
        scope.append(priviledge);
        if (params != null && params.size() > 0) {
            String paramsJoined = this.generateParamString(params);
            scope.append("?");
            scope.append(paramsJoined);
        }
        return scope.toString();
    }

    public void allowClientOutgoing(String appSid) {
        this.allowClientOutgoing(appSid, null);
    }

    public void allowClientOutgoing(String appSid, Map<String, String> params) {
        this.buildOutgoingScope = true;
        this.outgoingParams = params;
        this.appSid = appSid;
    }

    private String generateParamString(Map<String, String> params) {
        ArrayList<String> keyValues = new ArrayList<String>();
        for (String key : params.keySet()) {
            String value = params.get(key);
            try {
                key = URLEncoder.encode(key, "UTF-8");
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                continue;
            }
            keyValues.add(key + "=" + value);
        }
        String paramsJoined = StringUtils.join(keyValues, (char)'&');
        return paramsJoined;
    }

    public void allowClientIncoming(String clientName) {
        this.incomingClientName = clientName;
        this.buildIncomingScope = true;
    }

    public void allowEventStream(Map<String, String> filters) {
        LinkedHashMap<String, String> value = new LinkedHashMap<String, String>();
        value.put("path", "/2010-04-01/Events");
        if (filters != null) {
            String paramsJoined = this.generateParamString(filters);
            value.put("params", paramsJoined);
        }
        this.scopes.add(this.buildScopeString("stream", "subscribe", value));
    }

    public String generateToken() throws DomainException {
        return this.generateToken(3600L);
    }

    public String generateToken(long ttl) throws DomainException {
        this.buildIncomingScope();
        this.buildOutgoingScope();
        try {
            LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
            payload.put("iss", this.accountSid);
            payload.put("exp", String.valueOf(new Date().getTime() / 1000L + ttl));
            payload.put("scope", StringUtils.join(this.scopes, (char)' '));
            return TwilioCapability.jwtEncode(payload, this.authToken);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DomainException(e);
        }
    }

    private void buildOutgoingScope() {
        if (this.buildOutgoingScope) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("appSid", this.appSid);
            if (this.outgoingClientName != null) {
                values.put("clientName", this.outgoingClientName);
            } else if (this.incomingClientName != null) {
                values.put("clientName", this.incomingClientName);
            }
            if (this.outgoingParams != null) {
                String paramsJoined = this.generateParamString(this.outgoingParams);
                values.put("appParams", paramsJoined);
            }
            this.scopes.add(this.buildScopeString("client", "outgoing", values));
        }
    }

    private void buildIncomingScope() {
        if (this.buildIncomingScope) {
            LinkedHashMap<String, String> value = new LinkedHashMap<String, String>();
            if (this.incomingClientName == null) {
                throw new IllegalStateException("No client name set");
            }
            value.put("clientName", this.incomingClientName);
            this.scopes.add(this.buildScopeString("client", "incoming", value));
        }
    }

    private static String jwtEncode(Map<String, Object> payload, String key) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        header.put("typ", "JWT");
        header.put("alg", "HS256");
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(TwilioCapability.encodeBase64(TwilioCapability.jsonEncode(header)));
        segments.add(TwilioCapability.encodeBase64(TwilioCapability.jsonEncode(payload)));
        String signingInput = StringUtils.join(segments, (String)".");
        String signature = TwilioCapability.sign(signingInput, key);
        segments.add(signature);
        return StringUtils.join(segments, (String)".");
    }

    private static String jsonEncode(Object object) {
        String json = JSONValue.toJSONString((Object)object);
        return json.replace("\\/", "/");
    }

    private static String encodeBase64(String data) throws UnsupportedEncodingException {
        return TwilioCapability.encodeBase64(data.getBytes("UTF-8"));
    }

    private static String encodeBase64(byte[] data) throws UnsupportedEncodingException {
        String encodedString = new String(Base64.encodeBase64((byte[])data));
        String safeString = encodedString.replace('+', '-').replace('/', '_').replace("=", "");
        return safeString;
    }

    private static String sign(String data, String key) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        SecretKeySpec signingKey = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(data.getBytes("UTF-8"));
        String result = TwilioCapability.encodeBase64(rawHmac);
        return result;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: java com.twilio.client.TwilioCapability accountSid authToken");
            return;
        }
        TwilioCapability capability = new TwilioCapability(args[0], args[1]);
        capability.allowEventStream(null);
        capability.allowClientIncoming("Frank");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("foo", "fooval");
        capability.allowClientOutgoing("APabe7650f654fc34655fc81ae71caa3ff", params);
        try {
            String token = capability.generateToken();
            System.out.println(token);
        }
        catch (DomainException e) {
            e.printStackTrace();
        }
    }

    public static class DomainException
    extends Exception {
        public DomainException(String message) {
            super(message);
        }

        public DomainException(Exception e) {
            super(e);
        }
    }
}

