/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.factory.FeedbackFactory;
import com.twilio.sdk.resource.factory.impl.FeedbackFactoryImpl;
import com.twilio.sdk.resource.instance.Feedback;
import com.twilio.sdk.resource.list.RecordingList;
import com.twilio.sdk.resource.list.TranscriptionList;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class Call
extends InstanceResource {
    private static final String SID_PROPERTY = "sid";

    public Call(TwilioRestClient client) {
        super(client);
    }

    public Call(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a Call can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
    }

    public Call(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return this.getResourceLocation(".json");
    }

    private String getResourceLocation(String extension) {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Calls/" + this.getSid() + extension;
    }

    public String getSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public TranscriptionList getTranscriptions() {
        TranscriptionList transcriptions = new TranscriptionList(this.getClient(), this.getSid());
        transcriptions.setRequestAccountSid(this.getRequestAccountSid());
        return transcriptions;
    }

    public RecordingList getRecordings() {
        RecordingList recordings = new RecordingList(this.getClient(), this.getSid());
        recordings.setRequestAccountSid(this.getRequestAccountSid());
        return recordings;
    }

    public String getParentCallSid() {
        return this.getProperty("parent_call_sid");
    }

    public Date getDateCreated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_created"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateUpdated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_updated"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getTo() {
        return this.getProperty("to");
    }

    public String getFrom() {
        return this.getProperty("from");
    }

    public String getPhoneNumberSid() {
        return this.getProperty("phone_number_sid");
    }

    public String getStatus() {
        return this.getProperty("status");
    }

    public String getStartTime() {
        return this.getProperty("start_time");
    }

    public String getEndTime() {
        return this.getProperty("end_time");
    }

    public String getDuration() {
        return this.getProperty("duration");
    }

    public String getPrice() {
        return this.getProperty("price");
    }

    public String getDirection() {
        return this.getProperty("direction");
    }

    public String getAnsweredBy() {
        return this.getProperty("answered_by");
    }

    public String getForwardedFrom() {
        return this.getProperty("forwarded_from");
    }

    public String getCallerName() {
        return this.getProperty("caller_name");
    }

    public FeedbackFactory getFeedbackFactory() {
        return new FeedbackFactoryImpl(this.getClient(), this.getResourceLocation(""));
    }

    public boolean deleteFeedback() throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation("") + "/Feedback.json", "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    public void setFeedback(List<NameValuePair> params) throws TwilioRestException {
        FeedbackFactory factory = this.getFeedbackFactory();
        factory.create(params);
    }

    public Feedback getFeedback() {
        Feedback feedback = new Feedback(this.getClient(), this.getResourceLocation());
        feedback.setRequestAccountSid(this.getRequestAccountSid());
        return feedback;
    }

    public Call redirect(String url, String method) throws TwilioRestException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("Method", method);
        vars.put("Url", url);
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", vars);
        Call c = new Call(this.getClient(), response.toMap());
        c.setRequestAccountSid(this.getRequestAccountSid());
        return c;
    }

    public Call hangup() throws TwilioRestException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("Status", "completed");
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", vars);
        Call c = new Call(this.getClient(), response.toMap());
        c.setRequestAccountSid(this.getRequestAccountSid());
        return c;
    }

    public Call cancel() throws TwilioRestException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("Status", "canceled");
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", vars);
        Call c = new Call(this.getClient(), response.toMap());
        c.setRequestAccountSid(this.getRequestAccountSid());
        return c;
    }
}

