/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Feedback
extends InstanceResource {
    public static final String QUALITY_SCORE_PROP = "quality_score";
    public static final String ISSUES_PROP = "issues";
    public static final String DATE_CREATED_PROP = "date_created";
    public static final String DATE_UPDATED_PROP = "date_updated";
    public static final String QUALITY_SCORE_PARAM = "QualityScore";
    public static final String ISSUE_PARAM = "Issue";
    private String parentLocation;

    public Feedback(TwilioRestClient client, Map<String, Object> properties, String parentLocation) {
        super(client, properties);
        this.parentLocation = parentLocation;
    }

    public Feedback(TwilioRestClient client, String parentLocation) {
        super(client);
        this.parentLocation = parentLocation;
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    @Override
    protected String getResourceLocation() {
        return this.parentLocation + "/Feedback.json";
    }

    public int getQualityScore() {
        Integer prop = (Integer)this.getObject(QUALITY_SCORE_PROP);
        if (prop != null) {
            return prop;
        }
        throw new IllegalStateException("The Feedback instance doesn't have the quality score property set.");
    }

    public Set<String> getIssues() {
        List props = (List)this.getObject(ISSUES_PROP);
        if (props != null) {
            HashSet issues = new HashSet(props);
            return Collections.unmodifiableSet(issues);
        }
        return null;
    }

    public Date getDateCreated() {
        return this.parseDate(this.getProperty(DATE_CREATED_PROP));
    }

    public Date getDateUpdated() {
        return this.parseDate(this.getProperty(DATE_UPDATED_PROP));
    }
}

