/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.list.TranscriptionList;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class Recording
extends InstanceResource {
    private static final String SID_PROPERTY = "sid";

    public Recording(TwilioRestClient client) {
        super(client);
    }

    public Recording(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a Recording can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
    }

    public Recording(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return this.getResourceLocation(".json");
    }

    protected String getResourceLocation(String extension) {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Recordings/" + this.getSid() + extension;
    }

    public String getSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public TranscriptionList getTranscriptions() {
        TranscriptionList transcriptions = TranscriptionList.recordingTranscriptionList(this.getClient(), this.getSid());
        transcriptions.setRequestAccountSid(this.getRequestAccountSid());
        return transcriptions;
    }

    public Date getDateCreated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_created"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateUpdated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_updated"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getCallSid() {
        return this.getProperty("call_sid");
    }

    public int getDuration() {
        return Integer.parseInt(this.getProperty("duration"));
    }

    public String getApiVersion() {
        return this.getProperty("api_version");
    }

    public InputStream getMedia(String extension) {
        return this.getClient().requestStream(this.getResourceLocation(extension), "GET", (Map<String, String>)null);
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

