/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.sip;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.factory.sip.CredentialListMappingFactory;
import com.twilio.sdk.resource.factory.sip.IpAccessControlListMappingFactory;
import com.twilio.sdk.resource.instance.sip.CredentialListMapping;
import com.twilio.sdk.resource.instance.sip.IpAccessControlListMapping;
import com.twilio.sdk.resource.list.sip.CredentialListMappingList;
import com.twilio.sdk.resource.list.sip.IpAccessControlListMappingList;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class Domain
extends InstanceResource {
    private static final String SID_PROPERTY = "sid";

    public Domain(TwilioRestClient client) {
        super(client);
    }

    public Domain(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a Domain can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
    }

    public Domain(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SIP/Domains/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public Date getDateCreated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_created"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateUpdated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_updated"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getAuthType() {
        return this.getProperty("auth_type");
    }

    public String getDomainName() {
        return this.getProperty("domain_name");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getVoiceFallbackMethod() {
        return this.getProperty("voice_fallback_method");
    }

    public String getVoiceFallbackUrl() {
        return this.getProperty("voice_fallback_url");
    }

    public String getVoiceMethod() {
        return this.getProperty("voice_method");
    }

    public String getVoiceStatusCallbackMethod() {
        return this.getProperty("voice_status_callback_method");
    }

    public String getVoiceStatusCallbackUrl() {
        return this.getProperty("voice_status_callback_url");
    }

    public String getVoiceUrl() {
        return this.getProperty("voice_url");
    }

    public IpAccessControlListMappingList getIpAccessControlListMappings() {
        IpAccessControlListMappingList ipAccessControlListMappingList = new IpAccessControlListMappingList(this.getClient(), this.getSid());
        ipAccessControlListMappingList.setRequestAccountSid(this.getRequestAccountSid());
        return ipAccessControlListMappingList;
    }

    public IpAccessControlListMapping getIpAccessControlListMapping(String ipAccessControlListMappingSid) {
        IpAccessControlListMapping ipAccessControlListMapping = new IpAccessControlListMapping(this.getClient(), this.getSid(), ipAccessControlListMappingSid);
        ipAccessControlListMapping.setRequestAccountSid(this.getRequestAccountSid());
        return ipAccessControlListMapping;
    }

    public IpAccessControlListMappingFactory getIpAccessControlListMappingFactory() {
        return this.getIpAccessControlListMappings();
    }

    public CredentialListMappingList getCredentialListMappings() {
        CredentialListMappingList credentialListMappingList = new CredentialListMappingList(this.getClient(), this.getSid());
        credentialListMappingList.setRequestAccountSid(this.getRequestAccountSid());
        return credentialListMappingList;
    }

    public CredentialListMapping getCredentialListMapping(String credentialListMappingSid) {
        CredentialListMapping credentialListMapping = new CredentialListMapping(this.getClient(), this.getSid(), credentialListMappingSid);
        credentialListMapping.setRequestAccountSid(this.getRequestAccountSid());
        return credentialListMapping;
    }

    public CredentialListMappingFactory getCredentialListMappingFactory() {
        return this.getCredentialListMappings();
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

