/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.ListResource;
import com.twilio.sdk.resource.instance.Transcription;
import java.util.Map;

public class TranscriptionList
extends ListResource<Transcription> {
    private static String requestCallSid;
    private static String requestRecordingSid;

    public static TranscriptionList callTranscriptionList(TwilioRestClient client, String callSid) {
        return new TranscriptionList(client, callSid);
    }

    public static TranscriptionList callTranscriptionList(TwilioRestClient client, String callSid, Map<String, String> filters) {
        return new TranscriptionList(client, callSid, filters);
    }

    public static TranscriptionList recordingTranscriptionList(TwilioRestClient client, String recordingSid) {
        TranscriptionList transcriptions = new TranscriptionList(client);
        requestRecordingSid = recordingSid;
        return transcriptions;
    }

    public static TranscriptionList recordingTranscriptionList(TwilioRestClient client, String recordingSid, Map<String, String> filters) {
        TranscriptionList transcriptions = new TranscriptionList(client, filters);
        requestRecordingSid = recordingSid;
        return transcriptions;
    }

    public TranscriptionList(TwilioRestClient client) {
        super(client);
    }

    public TranscriptionList(TwilioRestClient client, Map<String, String> filters) {
        super(client, filters);
    }

    public TranscriptionList(TwilioRestClient client, String callSid) {
        super(client);
        requestCallSid = callSid;
    }

    public TranscriptionList(TwilioRestClient client, String callSid, Map<String, String> filters) {
        super(client, filters);
        requestCallSid = callSid;
    }

    @Override
    protected String getResourceLocation() {
        if (requestCallSid != null) {
            return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Calls/" + this.getRequestCallSid() + "/Transcriptions.json";
        }
        if (requestRecordingSid != null) {
            return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Recordings/" + requestRecordingSid + "/Transcriptions.json";
        }
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Transcriptions.json";
    }

    @Override
    protected Transcription makeNew(TwilioRestClient client, Map<String, Object> params) {
        return new Transcription(client, params);
    }

    @Override
    protected String getListKey() {
        return "transcriptions";
    }

    public String getRequestCallSid() {
        return requestCallSid;
    }

    public String getRequestRecordingSid() {
        return requestRecordingSid;
    }
}

