/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource;

import com.twilio.sdk.TwilioClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class Resource<C extends TwilioClient> {
    private C client;
    private String requestAccountSid;
    protected Map<String, String> filters;
    protected static final DateTimeFormatter ISO_8601_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'").withZoneUTC();
    private boolean loaded;

    public Resource(C client) {
        this.client = client;
    }

    protected C getClient() {
        return this.client;
    }

    protected void load(Map<String, String> params) throws TwilioRestException {
        String path = this.getResourceLocation();
        TwilioRestResponse response = ((TwilioClient)this.getClient()).safeRequest(path, "GET", params);
        this.parseResponse(response);
        this.loaded = true;
    }

    protected abstract void parseResponse(TwilioRestResponse var1);

    protected boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    protected String getRequestAccountSid() {
        return this.requestAccountSid;
    }

    public void setRequestAccountSid(String sid) {
        this.requestAccountSid = sid;
    }

    protected Calendar parseCalendar(String inDate) {
        if (inDate == null) {
            return null;
        }
        try {
            GregorianCalendar c = new GregorianCalendar();
            Date d = DateTime.parse((String)inDate, (DateTimeFormatter)ISO_8601_DATE_FORMAT).toDate();
            c.setTime(d);
            return c;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected String formatCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        long millis = calendar.getTimeInMillis();
        return ISO_8601_DATE_FORMAT.print(millis);
    }

    protected abstract String getResourceLocation();
}

