/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.instance.Media;
import com.twilio.sdk.resource.list.MediaList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Message
extends InstanceResource<TwilioRestClient> {
    public Message(TwilioRestClient client) {
        super(client);
    }

    public Message(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a Message can not be null");
        }
        this.setProperty("sid", sid);
    }

    public Message(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Messages/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public MediaList getMedia() {
        MediaList media = new MediaList((TwilioRestClient)this.getClient(), this.getSid());
        media.setRequestAccountSid(this.getRequestAccountSid());
        return media;
    }

    public Media getMedia(String mediaSid) {
        Media media = new Media((TwilioRestClient)this.getClient(), this.getSid(), mediaSid);
        media.setRequestAccountSid(this.getRequestAccountSid());
        return media;
    }

    public Date getDateCreated() {
        return this.parseDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseDate(this.getProperty("date_updated"));
    }

    public Date getDateSent() {
        return this.parseDate(this.getProperty("date_sent"));
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getTo() {
        return this.getProperty("to");
    }

    public String getFrom() {
        return this.getProperty("from");
    }

    public String getMessagingServiceSid() {
        return this.getProperty("messaging_service_sid");
    }

    public String getBody() {
        return this.getProperty("body");
    }

    public String getStatus() {
        return this.getProperty("status");
    }

    public String getPrice() {
        return this.getProperty("price");
    }

    public String getPriceUnit() {
        return this.getProperty("price_unit");
    }

    public int getNumSegments() {
        return Integer.parseInt(this.getProperty("num_segments"));
    }

    public int getNumMedia() {
        return Integer.parseInt(this.getProperty("num_media"));
    }

    public String getDirection() {
        return this.getProperty("direction");
    }

    public String getApiVersion() {
        return this.getProperty("api_version");
    }

    public Integer getErrorCode() {
        try {
            return (Integer)this.getObject("error_code");
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getErrorMessage() {
        return this.getProperty("error_message");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    public Message redact() throws TwilioRestException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Body", "");
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        Message redacted = new Message((TwilioRestClient)this.getClient(), response.toMap());
        redacted.setRequestAccountSid(this.getRequestAccountSid());
        return redacted;
    }
}

