/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.taskrouter.StatisticsQueryBuilder;
import com.twilio.sdk.resource.instance.taskrouter.WorkflowStatistics;
import com.twilio.sdk.taskrouter.WorkflowConfiguration;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Workflow
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public Workflow(TwilioTaskRouterClient client) {
        super(client);
    }

    public Workflow(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Workflow(TwilioTaskRouterClient client, String workspaceSid, String workflowSid) {
        super(client);
        if (StringUtils.isBlank((CharSequence)workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for an Workflow cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)workflowSid)) {
            throw new IllegalArgumentException("The workflowSid for an Workflow cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty("sid", workflowSid);
    }

    public String getAssignmentCallbackUrl() {
        return this.getProperty("assignment_callback_url");
    }

    public String getConfiguration() {
        return this.getProperty("configuration");
    }

    public WorkflowConfiguration parseConfiguration() throws IOException {
        String configurationJSON = this.getProperty("configuration");
        return WorkflowConfiguration.parse(configurationJSON);
    }

    public Date getDateCreated() {
        return this.parseDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseDate(this.getProperty("date_updated"));
    }

    public String getFallbackAssignmentCallbackUrl() {
        return this.getProperty("fallback_assignment_callback_url");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public Integer getTaskReservationTimeout() {
        return (Integer)this.getObject("task_reservation_timeout");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    public WorkflowStatistics getStatistics() {
        return this.getStatistics(new HashMap<String, String>());
    }

    public WorkflowStatistics getStatistics(StatisticsQueryBuilder queryBuilder) {
        HashMap<String, String> filters = new HashMap<String, String>();
        Calendar startDate = queryBuilder.getStartDate();
        Calendar endDate = queryBuilder.getEndDate();
        Integer minutes = queryBuilder.getMinutes();
        if (startDate != null) {
            filters.put("StartDate", this.formatCalendar(startDate));
        }
        if (endDate != null) {
            filters.put("EndDate", this.formatCalendar(endDate));
        }
        if (minutes != null) {
            filters.put("Minutes", minutes.toString());
        }
        return this.getStatistics(filters);
    }

    public WorkflowStatistics getStatistics(Map<String, String> filters) {
        String startDate = filters.get("StartDate");
        String endDate = filters.get("EndDate");
        String minutes = filters.get("Minutes");
        if ((startDate != null || endDate != null) && minutes != null) {
            throw new IllegalArgumentException("Cannot provide Minutes in combination with StartDate or EndDate");
        }
        WorkflowStatistics statistics = new WorkflowStatistics((TwilioTaskRouterClient)this.getClient(), this.getWorkspaceSid(), this.getSid(), filters);
        return statistics;
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Workflows/" + this.getSid();
    }
}

