/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.taskrouter;

import com.twilio.sdk.taskrouter.FilterRequirement;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class Policy
implements JSONAware {
    protected final String url;
    protected final String method;
    protected Map<String, FilterRequirement> queryFilter;
    protected Map<String, FilterRequirement> postFilter;
    protected final boolean allowed;

    public Policy(String url, String method, Map<String, FilterRequirement> queryFilter, Map<String, FilterRequirement> postFilter, boolean allowed) {
        this.url = url;
        this.method = method;
        this.queryFilter = queryFilter;
        this.postFilter = postFilter;
        this.allowed = allowed;
    }

    public Policy(String url, String method, boolean allowed) {
        this(url, method, new HashMap<String, FilterRequirement>(), new HashMap<String, FilterRequirement>(), allowed);
    }

    public Policy addQueryFilterParam(String name, FilterRequirement required) {
        this.queryFilter.put(name, required);
        return this;
    }

    public Policy addPostFilterParam(String name, FilterRequirement required) {
        this.postFilter.put(name, required);
        return this;
    }

    public Policy setQueryFilter(Map<String, FilterRequirement> queryFilter) {
        this.queryFilter = queryFilter;
        return this;
    }

    public Policy setPostFilter(Map<String, FilterRequirement> postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    public String toJSONString() {
        JSONObject obj = new JSONObject();
        obj.put((Object)"url", (Object)this.url);
        obj.put((Object)"method", (Object)this.method);
        obj.put((Object)"allow", (Object)this.allowed);
        JSONObject query = new JSONObject();
        JSONObject post = new JSONObject();
        if (this.queryFilter != null) {
            for (Map.Entry<String, FilterRequirement> e : this.queryFilter.entrySet()) {
                query.put((Object)e.getKey(), (Object)e.getValue());
            }
        }
        if (this.postFilter != null) {
            for (Map.Entry<String, FilterRequirement> e : this.postFilter.entrySet()) {
                post.put((Object)e.getKey(), (Object)e.getValue());
            }
        }
        obj.put((Object)"query_filter", (Object)query);
        obj.put((Object)"post_filter", (Object)post);
        return obj.toJSONString();
    }

    public String toString() {
        return "Policy [url=" + this.url + ", method=" + this.method + ", queryFilter=" + this.queryFilter + ", postFilter=" + this.postFilter + ", allowed=" + this.allowed + "]";
    }
}

