/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.taskrouter;

import com.twilio.sdk.CapabilityToken;
import com.twilio.sdk.taskrouter.FilterRequirement;
import com.twilio.sdk.taskrouter.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TaskRouterCapability
extends CapabilityToken {
    private static final String TASKROUTER_BASE_URL = "https://taskrouter.twilio.com";
    private static final String TASKROUTER_VERSION = "v1";
    private static final String TASKROUTER_EVENT_URL = "https://event-bridge.twilio.com/v1/wschannels";
    protected String accountSid;
    protected String authToken;
    protected Set<Policy> policies;
    protected String version;
    protected String friendlyName;
    protected String workspaceSid;
    protected String channelId;
    protected String resourceUrl;
    protected String baseUrl;

    public TaskRouterCapability(String accountSid, String authToken, String workspaceSid, String channelId) {
        this.accountSid = accountSid;
        this.authToken = authToken;
        this.version = TASKROUTER_VERSION;
        this.friendlyName = channelId;
        this.workspaceSid = workspaceSid;
        this.channelId = channelId;
        this.policies = new LinkedHashSet<Policy>();
        this.baseUrl = "https://taskrouter.twilio.com/v1/Workspaces/" + workspaceSid;
        this.validateJWT();
        this.setupResource();
        this.addTaskRouterPolicies(channelId);
        this.addPolicy(new Policy(this.resourceUrl, "GET", true));
    }

    protected void setupResource() {
        if (this.channelId.startsWith("WS")) {
            this.resourceUrl = this.baseUrl;
        } else if (this.channelId.startsWith("WK")) {
            this.resourceUrl = this.baseUrl + "/Workers/" + this.channelId;
            String activityUrl = this.baseUrl + "/Activities";
            String reservationsUrl = this.baseUrl + "/Tasks/**";
            this.allow(activityUrl, "GET", null, null);
            this.allow(reservationsUrl, "GET", null, null);
        } else if (this.channelId.startsWith("WQ")) {
            this.resourceUrl = this.baseUrl + "/TaskQueues/" + this.channelId;
        }
    }

    private void addTaskRouterPolicies(String channelId) {
        String eventBridgeUrl = "https://event-bridge.twilio.com/v1/wschannels/" + this.accountSid + "/" + channelId;
        this.addPolicy(new Policy(eventBridgeUrl, "GET", true));
        this.addPolicy(new Policy(eventBridgeUrl, "POST", true));
    }

    private void validateJWT() {
        if (this.accountSid == null || !this.accountSid.startsWith("AC")) {
            throw new IllegalArgumentException("Invalid AccountSid provided: " + this.accountSid);
        }
        if (this.workspaceSid == null || !this.workspaceSid.startsWith("WS")) {
            throw new IllegalArgumentException("Invalid WorkspaceSid provided: " + this.workspaceSid);
        }
        if (this.channelId == null) {
            throw new IllegalArgumentException("ChannelId not provided");
        }
        if (!(this.channelId.startsWith("WS") || this.channelId.startsWith("WK") || this.channelId.startsWith("WQ"))) {
            throw new IllegalArgumentException("Invalid ChannelId provided: " + this.channelId);
        }
    }

    public void allowFetchSubresources() {
        this.allow(this.resourceUrl + "/**", "GET", null, null);
    }

    public void allowUpdates() {
        this.allow(this.resourceUrl, "POST", null, null);
    }

    public void allowUpdatesSubresources() {
        this.allow(this.resourceUrl + "/**", "POST", null, null);
    }

    public void allowDelete() {
        this.allow(this.resourceUrl, "DELETE", null, null);
    }

    public void allowDeleteSubresources() {
        this.allow(this.resourceUrl + "/**", "DELETE", null, null);
    }

    @Deprecated
    public void allowWorkerActivityUpdates() {
        if (!this.channelId.startsWith("WK")) {
            throw new UnsupportedOperationException("Deprecated function not applicable to non Worker");
        }
        Policy update = new Policy(this.resourceUrl, "POST", true).addPostFilterParam("ActivitySid", FilterRequirement.REQUIRED);
        this.addPolicy(update);
    }

    @Deprecated
    public void allowWorkerFetchAttributes() {
        if (!this.channelId.startsWith("WK")) {
            throw new UnsupportedOperationException("Deprecated function not applicable to non Worker");
        }
        this.addPolicy(new Policy(this.resourceUrl, "GET", true));
    }

    @Deprecated
    public void allowTaskReservationUpdates() {
        if (!this.channelId.startsWith("WK")) {
            throw new UnsupportedOperationException("Deprecated function not applicable to non Worker");
        }
        String tasksUrl = this.baseUrl + "/Tasks/**";
        Policy update = new Policy(tasksUrl, "POST", true);
        this.addPolicy(update);
    }

    public TaskRouterCapability addPolicy(Policy policy) {
        this.policies.add(policy);
        return this;
    }

    public void addPolicy(String url, String method, Map<String, FilterRequirement> queryFilter, Map<String, FilterRequirement> postFilter, boolean allow) {
        this.policies.add(new Policy(url, method, queryFilter, postFilter, allow));
    }

    public void allow(String url, String method, Map<String, FilterRequirement> queryFilter, Map<String, FilterRequirement> postFilter) {
        this.policies.add(new Policy(url, method, queryFilter, postFilter, true));
    }

    public void deny(String url, String method, Map<String, FilterRequirement> queryFilter, Map<String, FilterRequirement> postFilter) {
        this.policies.add(new Policy(url, method, queryFilter, postFilter, false));
    }

    public String generateToken() throws CapabilityToken.DomainException {
        return this.generateToken(3600L);
    }

    public String generateToken(long ttl) throws CapabilityToken.DomainException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("iss", this.accountSid);
        payload.put("exp", System.currentTimeMillis() / 1000L + ttl);
        payload.put("account_sid", this.accountSid);
        payload.put("friendly_name", this.friendlyName);
        payload.put("version", this.version);
        payload.put("policies", new ArrayList<Policy>(this.policies));
        payload.put("workspace_sid", this.workspaceSid);
        payload.put("channel", this.channelId);
        if (this.channelId.startsWith("WK")) {
            payload.put("worker_sid", this.channelId);
        } else if (this.channelId.startsWith("WQ")) {
            payload.put("taskqueue_sid", this.channelId);
        }
        try {
            return TaskRouterCapability.jwtEncode(payload, this.authToken);
        }
        catch (Exception e) {
            throw new CapabilityToken.DomainException(e);
        }
    }
}

