/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.taskrouter;

import com.twilio.sdk.taskrouter.FilterRequirement;
import com.twilio.sdk.taskrouter.Policy;
import com.twilio.sdk.taskrouter.TaskRouterCapability;

public class TaskRouterWorkerCapability
extends TaskRouterCapability {
    private final String reservationsUrl;
    private final String activityUrl;

    public TaskRouterWorkerCapability(String accountSid, String authToken, String workspaceSid, String workerSid) {
        super(accountSid, authToken, workspaceSid, workerSid);
        this.reservationsUrl = this.baseUrl + "/Tasks/**";
        this.activityUrl = this.baseUrl + "/Activities";
        this.allow(this.activityUrl, "GET", null, null);
        this.allow(this.reservationsUrl, "GET", null, null);
    }

    @Override
    protected void setupResource() {
        this.resourceUrl = this.baseUrl + "/Workers/" + this.channelId;
    }

    public void allowActivityUpdates() {
        Policy policy = new Policy(this.resourceUrl, "POST", true);
        policy.postFilter.put("ActivitySid", FilterRequirement.REQUIRED);
        this.policies.add(policy);
    }

    public void allowReservationUpdates() {
        Policy policy = new Policy(this.reservationsUrl, "POST", true);
        this.policies.add(policy);
    }
}

