/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import com.twilio.sdk.TwilioClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.instance.taskrouter.Activity;
import com.twilio.sdk.resource.instance.taskrouter.Event;
import com.twilio.sdk.resource.instance.taskrouter.Reservation;
import com.twilio.sdk.resource.instance.taskrouter.Task;
import com.twilio.sdk.resource.instance.taskrouter.TaskQueue;
import com.twilio.sdk.resource.instance.taskrouter.TaskQueueStatistics;
import com.twilio.sdk.resource.instance.taskrouter.Worker;
import com.twilio.sdk.resource.instance.taskrouter.WorkerStatistics;
import com.twilio.sdk.resource.instance.taskrouter.WorkersStatistics;
import com.twilio.sdk.resource.instance.taskrouter.Workflow;
import com.twilio.sdk.resource.instance.taskrouter.WorkflowStatistics;
import com.twilio.sdk.resource.instance.taskrouter.Workspace;
import com.twilio.sdk.resource.instance.taskrouter.WorkspaceStatistics;
import com.twilio.sdk.resource.list.taskrouter.ActivityList;
import com.twilio.sdk.resource.list.taskrouter.EventList;
import com.twilio.sdk.resource.list.taskrouter.ReservationList;
import com.twilio.sdk.resource.list.taskrouter.TaskList;
import com.twilio.sdk.resource.list.taskrouter.TaskQueueList;
import com.twilio.sdk.resource.list.taskrouter.TaskQueueListStatistics;
import com.twilio.sdk.resource.list.taskrouter.WorkerList;
import com.twilio.sdk.resource.list.taskrouter.WorkflowList;
import com.twilio.sdk.resource.list.taskrouter.WorkspaceList;
import java.util.HashMap;
import java.util.Map;

public class TwilioTaskRouterClient
extends TwilioClient {
    public static final String DEFAULT_VERSION = "v1";

    public TwilioTaskRouterClient(String username, String password) {
        super(username, password, "https://taskrouter.twilio.com");
    }

    public TwilioTaskRouterClient(String username, String password, String endpoint) {
        super(username, password, endpoint);
    }

    public Activity createActivity(String workspaceSid, Map<String, String> properties) throws TwilioRestException {
        ActivityList activityFactory = new ActivityList(this, workspaceSid);
        return (Activity)activityFactory.create(properties);
    }

    public TaskQueue createTaskQueue(String workspaceSid, Map<String, String> properties) throws TwilioRestException {
        TaskQueueList taskQueueFactory = new TaskQueueList(this, workspaceSid);
        return (TaskQueue)taskQueueFactory.create(properties);
    }

    public Task createTask(String workspaceSid, Map<String, String> properties) throws TwilioRestException {
        TaskList taskFactory = new TaskList(this, workspaceSid);
        return (Task)taskFactory.create(properties);
    }

    public Task createTask(String workspaceSid, String workflowSid, Map<String, String> attributes, Integer priority, Integer timeout) throws TwilioRestException {
        TaskList taskList = new TaskList(this, workspaceSid);
        return taskList.create(workflowSid, attributes, priority, timeout);
    }

    public Worker createWorker(String workspaceSid, Map<String, String> properties) throws TwilioRestException {
        WorkerList factory = new WorkerList(this, workspaceSid);
        return (Worker)factory.create(properties);
    }

    public Worker createWorker(String workspaceSid, String friendlyName, Map<String, String> attributes, String activitySid) throws TwilioRestException {
        WorkerList workerList = new WorkerList(this, workspaceSid);
        return workerList.create(friendlyName, attributes, activitySid);
    }

    public Workflow createWorkflow(String workspaceSid, Map<String, String> properties) throws TwilioRestException {
        WorkflowList factory = new WorkflowList(this, workspaceSid);
        return (Workflow)factory.create(properties);
    }

    public Workspace createWorkspace(Map<String, String> properties) throws TwilioRestException {
        WorkspaceList workspaceFactory = new WorkspaceList(this);
        return (Workspace)workspaceFactory.create(properties);
    }

    public boolean deleteActivity(String workspaceSid, String activitySid) throws TwilioRestException {
        TwilioRestResponse response = this.safeRequest("/v1/Workspaces/" + workspaceSid + "/Activities/" + activitySid, "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    public boolean deleteTaskQueue(String workspaceSid, String queueSid) throws TwilioRestException {
        TwilioRestResponse response = this.safeRequest("/v1/Workspaces/" + workspaceSid + "/TaskQueues/" + queueSid, "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    public boolean deleteTask(String workspaceSid, String taskSid) throws TwilioRestException {
        TwilioRestResponse response = this.safeRequest("/v1/Workspaces/" + workspaceSid + "/Tasks/" + taskSid, "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    public boolean deleteWorker(String workspaceSid, String workerSid) throws TwilioRestException {
        TwilioRestResponse response = this.safeRequest("/v1/Workspaces/" + workspaceSid + "/Workers/" + workerSid, "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    public boolean deleteWorkflow(String workspaceSid, String workflowSid) throws TwilioRestException {
        TwilioRestResponse response = this.safeRequest("/v1/Workspaces/" + workspaceSid + "/Workflows/" + workflowSid, "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    public boolean deleteWorkspace(String sid) throws TwilioRestException {
        TwilioRestResponse response = this.safeRequest("/v1/Workspaces/" + sid, "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    public ActivityList getActivities(String workspaceSid) {
        return this.getActivities(workspaceSid, new HashMap<String, String>(0));
    }

    public ActivityList getActivities(String workspaceSid, Map<String, String> filters) {
        ActivityList list = new ActivityList(this, workspaceSid, filters);
        return list;
    }

    public Activity getActivity(String workspaceSid, String activitySid) {
        Activity activity = new Activity(this, workspaceSid, activitySid);
        return activity;
    }

    public Event getEvent(String workspaceSid, String eventSid) {
        Event event = new Event(this, workspaceSid, eventSid);
        return event;
    }

    public EventList getEvents(String workspaceSid) {
        return this.getEvents(workspaceSid, new HashMap<String, String>(0));
    }

    public EventList getEvents(String workspaceSid, Map<String, String> filters) {
        EventList list = new EventList(this, workspaceSid, filters);
        return list;
    }

    public Reservation getReservation(String workspaceSid, String taskSid, String reservationSid) {
        Reservation reservation = new Reservation(this, workspaceSid, taskSid, reservationSid);
        return reservation;
    }

    public ReservationList getReservations(String workspaceSid, String taskSid) {
        return this.getReservations(workspaceSid, taskSid, new HashMap<String, String>(0));
    }

    public ReservationList getReservations(String workspaceSid, String taskSid, Map<String, String> filters) {
        ReservationList list = new ReservationList(this, workspaceSid, taskSid, filters);
        return list;
    }

    public TaskQueue getTaskQueue(String workspaceSid, String queueSid) {
        TaskQueue taskQueue = new TaskQueue(this, workspaceSid, queueSid);
        return taskQueue;
    }

    public TaskQueueList getTaskQueues(String workspaceSid) {
        return this.getTaskQueues(workspaceSid, new HashMap<String, String>(0));
    }

    public TaskQueueList getTaskQueues(String workspaceSid, Map<String, String> filters) {
        TaskQueueList list = new TaskQueueList(this, workspaceSid, filters);
        return list;
    }

    public TaskQueueListStatistics getQueuesStatistics(String workspaceSid) {
        return this.getQueuesStatistics(workspaceSid, null);
    }

    public TaskQueueListStatistics getQueuesStatistics(String workspaceSid, Map<String, String> filters) {
        TaskQueueListStatistics list = new TaskQueueListStatistics(this, workspaceSid, filters);
        return list;
    }

    public TaskQueueStatistics getQueueStatistics(String workspaceSid, String queueSid) {
        return this.getQueueStatistics(workspaceSid, queueSid, null);
    }

    public TaskQueueStatistics getQueueStatistics(String workspaceSid, String queueSid, Map<String, String> filters) {
        TaskQueueStatistics taskQueueStatistics = new TaskQueueStatistics(this, workspaceSid, queueSid, filters);
        return taskQueueStatistics;
    }

    public Task getTask(String workspaceSid, String taskSid) {
        Task task = new Task(this, workspaceSid, taskSid);
        return task;
    }

    public TaskList getTasks(String workspaceSid) {
        return this.getTasks(workspaceSid, new HashMap<String, String>(0));
    }

    public TaskList getTasks(String workspaceSid, Map<String, String> filters) {
        TaskList list = new TaskList(this, workspaceSid, filters);
        return list;
    }

    public Worker getWorker(String workspaceSid, String workerSid) {
        Worker worker = new Worker(this, workspaceSid, workerSid);
        return worker;
    }

    public WorkerList getWorkers(String workspaceSid) {
        return this.getWorkers(workspaceSid, new HashMap<String, String>(0));
    }

    public WorkerList getWorkers(String workspaceSid, Map<String, String> filters) {
        WorkerList list = new WorkerList(this, workspaceSid, filters);
        return list;
    }

    public WorkersStatistics getWorkersStatistics(String workspaceSid) {
        return this.getWorkersStatistics(workspaceSid, null);
    }

    public WorkersStatistics getWorkersStatistics(String workspaceSid, Map<String, String> filters) {
        WorkersStatistics workersStatistics = new WorkersStatistics(this, workspaceSid, filters);
        return workersStatistics;
    }

    public WorkerStatistics getWorkerStatistics(String workspaceSid, String workerSid) {
        return this.getWorkerStatistics(workspaceSid, workerSid, null);
    }

    public WorkerStatistics getWorkerStatistics(String workspaceSid, String workerSid, Map<String, String> filters) {
        WorkerStatistics workerStatistics = new WorkerStatistics(this, workspaceSid, workerSid, filters);
        return workerStatistics;
    }

    public Workflow getWorkflow(String workspaceSid, String workflowSid) {
        Workflow workflow = new Workflow(this, workspaceSid, workflowSid);
        return workflow;
    }

    public WorkflowList getWorkflows(String workspaceSid) {
        return this.getWorkflows(workspaceSid, new HashMap<String, String>(0));
    }

    public WorkflowList getWorkflows(String workspaceSid, Map<String, String> filters) {
        WorkflowList list = new WorkflowList(this, workspaceSid, filters);
        return list;
    }

    public WorkflowStatistics getWorkflowStatistics(String workspaceSid, String workflowSid) {
        return this.getWorkflowStatistics(workspaceSid, workflowSid, null);
    }

    public WorkflowStatistics getWorkflowStatistics(String workspaceSid, String workflowSid, Map<String, String> filters) {
        WorkflowStatistics workflowStatistics = new WorkflowStatistics(this, workspaceSid, workflowSid, filters);
        return workflowStatistics;
    }

    public Workspace getWorkspace(String sid) {
        Workspace workspace = new Workspace(this, sid);
        return workspace;
    }

    public WorkspaceList getWorkspaces() {
        return this.getWorkspaces(new HashMap<String, String>(0));
    }

    public WorkspaceList getWorkspaces(Map<String, String> filters) {
        WorkspaceList list = new WorkspaceList(this, filters);
        return list;
    }

    public WorkspaceStatistics getWorkspaceStatistics(String workspaceSid) {
        return this.getWorkspaceStatistics(workspaceSid, null);
    }

    public WorkspaceStatistics getWorkspaceStatistics(String workspaceSid, Map<String, String> filters) {
        WorkspaceStatistics workspaceStatistics = new WorkspaceStatistics(this, workspaceSid, filters);
        return workspaceStatistics;
    }
}

