/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource;

import com.twilio.sdk.TwilioClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.Resource;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.http.NameValuePair;
import org.json.simple.JSONObject;

public abstract class InstanceResource<C extends TwilioClient>
extends Resource<C> {
    protected static final String DATE_CREATED_PROPERTY = "date_created";
    protected static final String DATE_UPDATED_PROPERTY = "date_updated";
    protected static final String SID_PROPERTY = "sid";
    protected static final String ACCOUNT_SID_PROPERTY = "account_sid";
    protected static final String FRIENDLY_NAME_PROPERTY = "friendly_name";
    private Map<String, Object> properties;

    public InstanceResource(C client) {
        this(client, null, null);
    }

    public InstanceResource(C client, Map<String, Object> properties) {
        this(client, properties, null);
    }

    public InstanceResource(C client, Map<String, Object> properties, Map<String, String> filters) {
        super(client);
        this.properties = properties == null ? new HashMap<String, Object>() : new HashMap<String, Object>(properties);
        this.filters = filters == null ? new HashMap() : new HashMap<String, String>(filters);
        this.setLoaded(!this.properties.isEmpty());
    }

    private Object getAndLoadIfNecessary(String name) {
        Object prop = this.properties.get(name);
        if (prop == null && !this.isLoaded()) {
            try {
                this.load(this.filters);
                return this.properties.get(name);
            }
            catch (TwilioRestException e) {
                throw new RuntimeException(e);
            }
        }
        return prop;
    }

    public String getProperty(String name) {
        Object prop = this.getAndLoadIfNecessary(name);
        if (prop == null) {
            return null;
        }
        if (prop instanceof String) {
            return (String)prop;
        }
        throw new IllegalArgumentException("Property " + name + " is an object.  Use getObject() instead.");
    }

    public Object getObject(String name) {
        Object prop = this.getAndLoadIfNecessary(name);
        if (prop == null) {
            throw new IllegalArgumentException("Property " + name + " does not exist");
        }
        return prop;
    }

    public <T> T getCastedObject(String name) {
        return (T)this.getAndLoadIfNecessary(name);
    }

    public Integer getPropertyAsInteger(String name) {
        return (Integer)this.getObject(name);
    }

    protected Date getDateProperty(String name) {
        return this.parseDate(this.getProperty(name));
    }

    protected void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void update(Map<String, String> params) throws TwilioRestException {
        ((TwilioClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
    }

    public void update(List<NameValuePair> params) throws TwilioRestException {
        ((TwilioClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
    }

    @Override
    protected void parseResponse(TwilioRestResponse response) {
        Map<String, Object> properties = response.toMap();
        this.properties = new HashMap<String, Object>(properties);
    }

    public String toJSON() {
        return JSONObject.toJSONString(this.properties);
    }

    protected Date parseDate(String inDate) {
        return this.parseFormattedDate(DateFormatUtils.SMTP_DATETIME_FORMAT, inDate);
    }

    protected Date parseIsoDate(String inDate) {
        return this.parseFormattedDate(DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT, inDate);
    }

    protected Date parseFormattedDate(FastDateFormat inDateFormat, String inDate) {
        if (inDateFormat == null || inDate == null) {
            return null;
        }
        try {
            return inDateFormat.parse(inDate);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

