/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.instance.Participant;
import com.twilio.sdk.resource.list.ParticipantList;
import java.util.Date;
import java.util.Map;

public class Conference
extends InstanceResource<TwilioRestClient> {
    public Conference(TwilioRestClient client) {
        super(client);
    }

    public Conference(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a Conference can not be null");
        }
        this.setProperty("sid", sid);
    }

    public Conference(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Conferences/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public Date getDateCreated() {
        return this.getDateProperty("date_created");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("date_updated");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getStatus() {
        return this.getProperty("status");
    }

    public ParticipantList getParticipants() {
        ParticipantList list = new ParticipantList((TwilioRestClient)this.getClient(), this.getSid());
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Participant getParticipant(String callSid) {
        Participant participant = new Participant((TwilioRestClient)this.getClient(), this.getSid(), callSid);
        participant.setRequestAccountSid(this.getRequestAccountSid());
        return participant;
    }
}

