/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.conversations;

import com.twilio.sdk.TwilioConversationsClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Calendar;
import java.util.Map;

public class Conversation
extends NextGenInstanceResource<TwilioConversationsClient> {
    public Conversation(TwilioConversationsClient client) {
        super(client);
    }

    public Conversation(TwilioConversationsClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Conversation(TwilioConversationsClient client, String conversationSid) {
        super(client);
        if (conversationSid == null || "".equals(conversationSid)) {
            throw new IllegalArgumentException("The conversationSid cannot be null");
        }
        this.setProperty("sid", conversationSid);
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getStatus() {
        return this.getProperty("status");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public Calendar getDateCreated() {
        return this.parseCalendar(this.getProperty("date_created"));
    }

    public Calendar getStartTime() {
        return this.parseCalendar(this.getProperty("start_time"));
    }

    public Calendar getEndTime() {
        return this.parseCalendar(this.getProperty("end_time"));
    }

    public Integer getDuration() {
        return this.getPropertyAsInteger("duration");
    }

    public String getUrl() {
        return this.getProperty("url");
    }

    public String getParticipantsUrl() {
        Map links = (Map)this.getObject("links");
        return (String)links.get("participants");
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Conversations/" + this.getSid();
    }
}

