/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.conversations;

import com.twilio.sdk.TwilioConversationsClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Calendar;
import java.util.Map;

public class Participant
extends NextGenInstanceResource<TwilioConversationsClient> {
    private static final String CONVERSATION_SID = "conversation_sid";

    public Participant(TwilioConversationsClient client) {
        super(client);
    }

    public Participant(TwilioConversationsClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Participant(TwilioConversationsClient client, String conversationSid, String participantSid) {
        super(client);
        if (conversationSid == null || "".equals(conversationSid)) {
            throw new IllegalArgumentException("The conversationSid cannot be null");
        }
        this.setProperty(CONVERSATION_SID, conversationSid);
        this.setProperty("sid", participantSid);
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getAddress() {
        return this.getProperty("address");
    }

    public String getStatus() {
        return this.getProperty("status");
    }

    public String getConversationSid() {
        return this.getProperty(CONVERSATION_SID);
    }

    public Calendar getDateCreated() {
        return this.parseCalendar(this.getProperty("date_created"));
    }

    public Calendar getStartTime() {
        return this.parseCalendar(this.getProperty("start_time"));
    }

    public Calendar getEndTime() {
        return this.parseCalendar(this.getProperty("end_time"));
    }

    public Integer getDuration() {
        return this.getPropertyAsInteger("duration");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getUrl() {
        return this.getProperty("url");
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Conversations/" + this.getConversationSid() + "/Participants/" + this.getSid();
    }
}

