/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.ipmessaging;

import com.twilio.sdk.TwilioIPMessagingClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Message
extends NextGenInstanceResource<TwilioIPMessagingClient> {
    private static final String SERVICE_SID_PROPERTY = "service_sid";
    private static final String INDEX_PROPERTY = "index";
    private String channelSid;

    public Message(TwilioIPMessagingClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Message(TwilioIPMessagingClient client, String serviceSid, String channelSid, String sid) {
        super(client);
        if (StringUtils.isEmpty((CharSequence)serviceSid)) {
            throw new IllegalArgumentException("serviceSid cannot be null");
        }
        if (StringUtils.isEmpty((CharSequence)channelSid)) {
            throw new IllegalArgumentException("channelSid cannot be null");
        }
        if (StringUtils.isEmpty((CharSequence)sid)) {
            throw new IllegalArgumentException("sid cannot be null");
        }
        this.setProperty(SERVICE_SID_PROPERTY, serviceSid);
        this.channelSid = channelSid;
        this.setProperty("sid", sid);
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getServiceSid() {
        return this.getProperty(SERVICE_SID_PROPERTY);
    }

    public String getTo() {
        return this.getProperty("to");
    }

    public String getFrom() {
        return this.getProperty("from");
    }

    public Boolean isWasEdited() {
        return (Boolean)this.getObject("was_edited");
    }

    public String getBody() {
        return this.getProperty("body");
    }

    public Integer getIndex() {
        return this.getPropertyAsInteger(INDEX_PROPERTY);
    }

    public Calendar getDateCreated() {
        return this.parseCalendar(this.getProperty("date_created"));
    }

    public Calendar getDateUpdated() {
        return this.parseCalendar(this.getProperty("date_updated"));
    }

    public String getUrl() {
        return this.getProperty("url");
    }

    private String getChannelSid() {
        return this.channelSid == null ? this.getTo() : this.channelSid;
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioIPMessagingClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Services/" + this.getServiceSid() + "/Channels/" + this.getChannelSid() + "/Messages/" + this.getSid();
    }
}

