/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.ipmessaging;

import com.twilio.sdk.TwilioIPMessagingClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.ipmessaging.Channel;
import com.twilio.sdk.resource.instance.ipmessaging.Role;
import com.twilio.sdk.resource.instance.ipmessaging.User;
import com.twilio.sdk.resource.list.ipmessaging.ChannelList;
import com.twilio.sdk.resource.list.ipmessaging.RoleList;
import com.twilio.sdk.resource.list.ipmessaging.UserList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;

public class Service
extends NextGenInstanceResource<TwilioIPMessagingClient> {
    private static final String READ_STATUS_ENABLED_PROPERTY = "read_status_enabled";
    private static final String CONSUMPTION_REPORT_INTERVAL_PROPERTY = "consumption_report_interval";

    public Service(TwilioIPMessagingClient client, String sid) {
        super(client);
        if (StringUtils.isEmpty((CharSequence)sid)) {
            throw new IllegalArgumentException("sid cannot be null");
        }
        this.setProperty("sid", sid);
    }

    public Service(TwilioIPMessagingClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getDefaultServiceRoleSid() {
        return this.getProperty("default_service_role_sid");
    }

    public String getDefaultChannelRoleSid() {
        return this.getProperty("default_channel_role_sid");
    }

    public Boolean getReadStatusEnabled() {
        return (Boolean)this.getObject(READ_STATUS_ENABLED_PROPERTY);
    }

    public Integer getTypingIndicatorTimeout() {
        return (Integer)this.getObject("typing_indicator_timeout");
    }

    public Integer getConsumptionReportInterval() {
        return this.getPropertyAsInteger(CONSUMPTION_REPORT_INTERVAL_PROPERTY);
    }

    public Object getWebhooks() {
        return this.getObject("webhooks");
    }

    public String getUrl() {
        return this.getProperty("url");
    }

    public Calendar getDateCreated() {
        return this.parseCalendar(this.getProperty("date_created"));
    }

    public Calendar getDateUpdated() {
        return this.parseCalendar(this.getProperty("date_updated"));
    }

    public ChannelList getChannels() {
        return this.getChannels(null);
    }

    public ChannelList getChannels(Map<String, String> filters) {
        return new ChannelList((TwilioIPMessagingClient)this.getClient(), this.getSid(), filters);
    }

    public Channel getChannel(String sid) {
        return new Channel((TwilioIPMessagingClient)this.getClient(), this.getSid(), sid);
    }

    public RoleList getRoles() {
        return this.getRoles(null);
    }

    public RoleList getRoles(Map<String, String> filters) {
        return new RoleList((TwilioIPMessagingClient)this.getClient(), this.getSid(), filters);
    }

    public Role getRole(String sid) {
        return new Role((TwilioIPMessagingClient)this.getClient(), this.getSid(), sid);
    }

    public Role createRole(Map<String, String> params) throws TwilioRestException {
        return this.getRoles().create((Map)params);
    }

    public Role createRole(List<NameValuePair> params) throws TwilioRestException {
        return this.getRoles().create((List)params);
    }

    public UserList getUsers() {
        return this.getUsers(null);
    }

    public User getUser(String sid) {
        return new User((TwilioIPMessagingClient)this.getClient(), this.getSid(), sid);
    }

    public UserList getUsers(Map<String, String> filters) {
        return new UserList((TwilioIPMessagingClient)this.getClient(), this.getSid(), filters);
    }

    public User createUser(Map<String, String> params) throws TwilioRestException {
        return this.getUsers().create((Map)params);
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioIPMessagingClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    public Channel createChannel(Map<String, String> params) throws TwilioRestException {
        return this.getChannels().create((Map)params);
    }

    public Channel createChannel(List<NameValuePair> params) throws TwilioRestException {
        return this.getChannels().create((List)params);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Services/" + this.getSid();
    }
}

