/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.sip;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.util.Date;
import java.util.Map;

public class IpAddress
extends InstanceResource<TwilioRestClient> {
    private String ipAccessControlListSid;

    public IpAddress(TwilioRestClient client) {
        super(client);
    }

    public IpAddress(TwilioRestClient client, String ipAccessControlListSid, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for an IpAddress can not be null");
        }
        if (ipAccessControlListSid == null) {
            throw new IllegalStateException("The Sid for an ip access control list can not be null");
        }
        this.setProperty("sid", sid);
        this.ipAccessControlListSid = ipAccessControlListSid;
    }

    public IpAddress(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SIP/IpAccessControlLists/" + this.getIpAccessControlListSid() + "/IpAddresses/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getIpAccessControlListSid() {
        return this.ipAccessControlListSid;
    }

    public Date getDateCreated() {
        return this.getDateProperty("date_created");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("date_updated");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getIpAddress() {
        return this.getProperty("ip_address");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

