/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.list.taskrouter.ReservationList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Task
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";
    private static JSONParser parser = new JSONParser();

    public Task(TwilioTaskRouterClient client) {
        super(client);
    }

    public Task(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Task(TwilioTaskRouterClient client, String workspaceSid, String taskSid) {
        super(client);
        if (StringUtils.isBlank((CharSequence)workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for an Task cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)taskSid)) {
            throw new IllegalArgumentException("The taskSid for an Task cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty("sid", taskSid);
    }

    public void update(Map<String, String> attributes, Integer priority) throws TwilioRestException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (attributes != null) {
            params.put("Attributes", JSONObject.toJSONString(attributes));
        } else {
            params.put("Attributes", "{}");
        }
        if (priority != null) {
            params.put("Priority", priority.toString());
        }
        this.update(params);
    }

    public void cancel(String reason) throws TwilioRestException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("AssignmentStatus", "canceled");
        if (reason != null) {
            params.put("Reason", reason);
        }
        this.update(params);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public int getAge() {
        Integer prop = (Integer)this.getObject("age");
        if (prop != null) {
            return prop;
        }
        throw new IllegalStateException("The Task doesn't have its age set");
    }

    public String getAssignmentStatus() {
        return this.getProperty("assignment_status");
    }

    public String getAttributes() {
        return this.getProperty("attributes");
    }

    public Map<String, Object> parseAttributes() throws ParseException {
        String attributes = this.getProperty("attributes");
        return (Map)parser.parse(attributes);
    }

    public Date getDateCreated() {
        return this.parseIsoDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseIsoDate(this.getProperty("date_updated"));
    }

    public int getPriority() {
        Integer prop = (Integer)this.getObject("priority");
        if (prop != null) {
            return prop;
        }
        throw new IllegalStateException("The Task doesn't have its priority set");
    }

    public int getTimeout() {
        return (Integer)this.getObject("timeout");
    }

    public String getQueueSid() {
        return this.getProperty("task_queue_sid");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getWorkflowSid() {
        return this.getProperty("workflow_sid");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    public String getReason() {
        return this.getProperty("reason");
    }

    public ReservationList getReservations() {
        ReservationList list = new ReservationList((TwilioTaskRouterClient)this.getClient(), this.getWorkspaceSid(), this.getSid());
        return list;
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Tasks/" + this.getSid();
    }
}

