/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.taskrouter.StatisticsQueryBuilder;
import com.twilio.sdk.resource.instance.taskrouter.WorkerStatistics;
import com.twilio.sdk.resource.list.taskrouter.WorkerReservationList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Worker
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";
    private static JSONParser parser = new JSONParser();

    public Worker(TwilioTaskRouterClient client) {
        super(client);
    }

    public Worker(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Worker(TwilioTaskRouterClient client, String workspaceSid, String workerSid) {
        super(client);
        if (StringUtils.isBlank((CharSequence)workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for an Worker cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)workerSid)) {
            throw new IllegalArgumentException("The workerSid for an Worker cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty("sid", workerSid);
    }

    public void update(Map<String, String> attributes, String friendlyName, String activitySid) throws TwilioRestException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (attributes != null) {
            params.put("Attributes", JSONObject.toJSONString(attributes));
        } else {
            params.put("Attributes", "{}");
        }
        if (friendlyName != null) {
            params.put("FriendlyName", friendlyName);
        }
        if (activitySid != null) {
            params.put("ActivitySid", activitySid);
        }
        this.update(params);
    }

    public void updateActivity(String activitySid) throws TwilioRestException {
        if (StringUtils.isBlank((CharSequence)activitySid)) {
            throw new IllegalArgumentException("The activitySid for updating a Worker's Activity cannot be null");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ActivitySid", activitySid);
        this.update(params);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getActivityName() {
        return this.getProperty("activity_name");
    }

    public String getActivitySid() {
        return this.getProperty("activity_sid");
    }

    public String getAttributes() {
        return this.getProperty("attributes");
    }

    public Map<String, Object> parseAttributes() throws ParseException {
        String attributes = this.getProperty("attributes");
        return (Map)parser.parse(attributes);
    }

    public Date getDateCreated() {
        return this.parseIsoDate(this.getProperty("date_created"));
    }

    public Date getDateStatusChanged() {
        return this.parseIsoDate(this.getProperty("date_status_changed"));
    }

    public Date getDateUpdated() {
        return this.parseIsoDate(this.getProperty("date_updated"));
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    public boolean isAvailable() {
        return (Boolean)this.getObject("available");
    }

    public WorkerStatistics getStatistics() {
        return this.getWorkerStatistics(new HashMap<String, String>());
    }

    public WorkerStatistics getWorkerStatistics(StatisticsQueryBuilder queryBuilder) {
        HashMap<String, String> filters = new HashMap<String, String>();
        Calendar startDate = queryBuilder.getStartDate();
        Calendar endDate = queryBuilder.getEndDate();
        Integer minutes = queryBuilder.getMinutes();
        if (startDate != null) {
            filters.put("StartDate", this.formatCalendar(startDate));
        }
        if (endDate != null) {
            filters.put("EndDate", this.formatCalendar(endDate));
        }
        if (minutes != null) {
            filters.put("Minutes", minutes.toString());
        }
        return this.getWorkerStatistics(filters);
    }

    public WorkerStatistics getWorkerStatistics(Map<String, String> filters) {
        String startDate = filters.get("StartDate");
        String endDate = filters.get("EndDate");
        String minutes = filters.get("Minutes");
        if ((startDate != null || endDate != null) && minutes != null) {
            throw new IllegalArgumentException("Cannot provide Minutes in combination with StartDate or EndDate");
        }
        WorkerStatistics statistics = new WorkerStatistics((TwilioTaskRouterClient)this.getClient(), this.getWorkspaceSid(), this.getSid(), filters);
        return statistics;
    }

    public WorkerReservationList getReservations() {
        return this.getReservations(null);
    }

    public WorkerReservationList getReservations(Map<String, String> filters) {
        return new WorkerReservationList((TwilioTaskRouterClient)this.getClient(), this.getWorkspaceSid(), this.getSid(), filters);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Workers/" + this.getSid();
    }
}

