/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.taskrouter.ActivityDuration;
import com.twilio.sdk.resource.instance.taskrouter.ActivityStatistic;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class WorkersStatistics
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String CUMULATIVE_PROPERTY = "cumulative";
    private static final String REALTIME_PROPERTY = "realtime";
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public WorkersStatistics(TwilioTaskRouterClient client, String workspaceSid) {
        this(client, workspaceSid, null);
    }

    public WorkersStatistics(TwilioTaskRouterClient client, String workspaceSid, Map<String, String> filters) {
        super(client);
        if (StringUtils.isBlank((CharSequence)workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for a WorkerStatistics cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.filters = filters;
    }

    public Set<ActivityDuration> getActivityDurations() {
        try {
            List props = (List)this.getCumulative().get("activity_durations");
            HashSet<ActivityDuration> activityDurations = new HashSet<ActivityDuration>();
            for (Map prop : props) {
                ActivityDuration activityDuration = this.mapToActivityDuration(prop);
                activityDurations.add(activityDuration);
            }
            return Collections.unmodifiableSet(activityDurations);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Set<ActivityStatistic> getActivityStatistics() {
        try {
            List props = (List)this.getRealtime().get("activity_statistics");
            HashSet<ActivityStatistic> activityStatistics = new HashSet<ActivityStatistic>();
            for (Map prop : props) {
                ActivityStatistic activityStatistic = this.mapToActivityStatistic(prop);
                activityStatistics.add(activityStatistic);
            }
            return Collections.unmodifiableSet(activityStatistics);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Calendar getEndTime() {
        return this.parseCalendar((String)this.getCumulative().get("end_time"));
    }

    public Integer getReservationsAccepted() {
        return (Integer)this.getCumulative().get("reservations_accepted");
    }

    public Integer getReservationsRejected() {
        return (Integer)this.getCumulative().get("reservations_rejected");
    }

    public Integer getReservationsTimedOut() {
        return (Integer)this.getCumulative().get("reservations_timed_out");
    }

    public Calendar getStartTime() {
        return this.parseCalendar((String)this.getCumulative().get("start_time"));
    }

    public Integer getTasksAssigned() {
        return (Integer)this.getCumulative().get("tasks_assigned");
    }

    public Integer getTotalWorkers() {
        return (Integer)this.getRealtime().get("total_workers");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Workers/Statistics";
    }

    private Map<String, Object> getCumulative() {
        return (Map)this.getObject(CUMULATIVE_PROPERTY);
    }

    private Map<String, Object> getRealtime() {
        return (Map)this.getObject(REALTIME_PROPERTY);
    }

    private ActivityDuration mapToActivityDuration(Map<String, Object> data) {
        Double average;
        Integer minimum;
        Integer maximum;
        String friendlyName;
        String sid;
        block5: {
            try {
                sid = (String)data.get("sid");
                friendlyName = (String)data.get("friendly_name");
                maximum = (Integer)data.get("maximum");
                minimum = (Integer)data.get("minimum");
                try {
                    Object prop = this.getObject("average");
                    if (prop instanceof Integer) {
                        average = Double.parseDouble(prop.toString());
                        break block5;
                    }
                    average = (Double)prop;
                }
                catch (IllegalArgumentException e) {
                    average = null;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("An Activity Duration contained improperly formatted data.", e);
            }
        }
        return new ActivityDuration(sid, friendlyName, average, maximum, minimum);
    }

    private ActivityStatistic mapToActivityStatistic(Map<String, Object> data) {
        Integer workers;
        String friendlyName;
        String sid;
        try {
            sid = (String)data.get("sid");
            friendlyName = (String)data.get("friendly_name");
            workers = (Integer)data.get("workers");
        }
        catch (Exception e) {
            throw new IllegalStateException("An Activity Statistic contained improperly formatted data.", e);
        }
        return new ActivityStatistic(sid, friendlyName, workers);
    }
}

