/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.trunking;

import com.twilio.sdk.TwilioTrunkingClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.trunking.CredentialList;
import com.twilio.sdk.resource.instance.trunking.IpAccessControlList;
import com.twilio.sdk.resource.instance.trunking.OriginationUrl;
import com.twilio.sdk.resource.instance.trunking.PhoneNumber;
import com.twilio.sdk.resource.list.trunking.CredentialListList;
import com.twilio.sdk.resource.list.trunking.IpAccessControlListList;
import com.twilio.sdk.resource.list.trunking.OriginationUrlList;
import com.twilio.sdk.resource.list.trunking.PhoneNumberList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Trunk
extends NextGenInstanceResource<TwilioTrunkingClient> {
    public Trunk(TwilioTrunkingClient client, String sid) {
        super(client, null);
        if (StringUtils.isEmpty((CharSequence)sid)) {
            throw new IllegalArgumentException("sid cannot be null");
        }
        this.setProperty("sid", sid);
    }

    public Trunk(TwilioTrunkingClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public OriginationUrlList getOriginationUrls() {
        return new OriginationUrlList((TwilioTrunkingClient)this.getClient(), this.getSid());
    }

    public OriginationUrlList getOriginationUrls(Map<String, String> filters) {
        return new OriginationUrlList((TwilioTrunkingClient)this.getClient(), this.getSid(), filters);
    }

    public OriginationUrl getOriginationUrl(String originationUrlSid) {
        return new OriginationUrl((TwilioTrunkingClient)this.getClient(), this.getSid(), originationUrlSid);
    }

    public CredentialListList getCredentialLists(Map<String, String> filters) {
        return new CredentialListList((TwilioTrunkingClient)this.getClient(), this.getSid(), filters);
    }

    public CredentialListList getCredentialLists() {
        return new CredentialListList((TwilioTrunkingClient)this.getClient(), this.getSid());
    }

    public CredentialList getCredentialList(String credentialListSid) {
        return new CredentialList((TwilioTrunkingClient)this.getClient(), this.getSid(), credentialListSid);
    }

    public IpAccessControlListList getIpAccessControlLists(Map<String, String> filters) {
        return new IpAccessControlListList((TwilioTrunkingClient)this.getClient(), this.getSid(), filters);
    }

    public IpAccessControlListList getIpAccessControlLists() {
        return new IpAccessControlListList((TwilioTrunkingClient)this.getClient(), this.getSid());
    }

    public IpAccessControlList getIpAccessControlList(String ipAccessControlListSid) {
        return new IpAccessControlList((TwilioTrunkingClient)this.getClient(), this.getSid(), ipAccessControlListSid);
    }

    public PhoneNumberList getPhoneNumbers() {
        return new PhoneNumberList((TwilioTrunkingClient)this.getClient(), this.getSid());
    }

    public PhoneNumberList getPhoneNumbers(Map<String, String> filters) {
        return new PhoneNumberList((TwilioTrunkingClient)this.getClient(), this.getSid(), filters);
    }

    public PhoneNumber getPhoneNumber(String phoneNumberSid) {
        return new PhoneNumber((TwilioTrunkingClient)this.getClient(), this.getSid(), phoneNumberSid);
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getDomainName() {
        return this.getProperty("domain_name");
    }

    public String getDisasterRecoveryMethod() {
        return this.getProperty("disaster_recovery_method");
    }

    public String getDisasterRecoveryUrl() {
        return this.getProperty("disaster_recovery_url");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public Boolean isSecure() {
        return (Boolean)this.getObject("secure");
    }

    public Recording getRecording() {
        return new Recording((Map)this.getObject("recording"));
    }

    public String getAuthType() {
        return this.getProperty("auth_type");
    }

    public List<String> getAuthTypeSet() {
        return (List)this.getObject("auth_type_set");
    }

    public Calendar getDateCreated() {
        return this.parseCalendar(this.getProperty("date_created"));
    }

    public Calendar getDateUpdated() {
        return this.parseCalendar(this.getProperty("date_updated"));
    }

    public String getUrl() {
        return this.getProperty("url");
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Trunks/" + this.getSid();
    }

    public class Recording {
        public static final String TRIM_SILIENCE = "trim-silence";
        public static final String DO_NOT_TRIM = "do-not-trim";
        public static final String DO_NOT_RECORD = "do-no-record";
        public static final String RECORD_FROM_ANSWER = "record-from-answer";
        public static final String RECORD_FROM_RINGING = "record-from-ringing";
        private final Map<String, Object> data;

        public Recording(Map<String, Object> data) {
            this.data = data;
        }

        public String getTrim() {
            return String.valueOf(this.data.get("trim"));
        }

        public String getMode() {
            return String.valueOf(this.data.get("mode"));
        }
    }
}

