/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.ListResource;
import com.twilio.sdk.resource.instance.Recording;
import java.util.Map;

public class RecordingList
extends ListResource<Recording, TwilioRestClient> {
    private static String requestCallSid;

    public RecordingList(TwilioRestClient client) {
        super(client);
    }

    public RecordingList(TwilioRestClient client, Map<String, String> filters) {
        super(client, filters);
    }

    public RecordingList(TwilioRestClient client, String callSid) {
        super(client);
        requestCallSid = callSid;
    }

    public RecordingList(TwilioRestClient client, String callSid, Map<String, String> filters) {
        super(client, filters);
        requestCallSid = callSid;
    }

    @Override
    protected String getResourceLocation() {
        if (requestCallSid != null) {
            return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Calls/" + this.getRequestCallSid() + "/Recordings.json";
        }
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Recordings.json";
    }

    @Override
    protected Recording makeNew(TwilioRestClient client, Map<String, Object> params) {
        return new Recording(client, params);
    }

    @Override
    protected String getListKey() {
        return "recordings";
    }

    public String getRequestCallSid() {
        return requestCallSid;
    }
}

