/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list.sip;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.ListResource;
import com.twilio.sdk.resource.factory.sip.IpAddressFactory;
import com.twilio.sdk.resource.instance.sip.IpAddress;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class IpAddressList
extends ListResource<IpAddress, TwilioRestClient>
implements IpAddressFactory {
    private String ipAccessControlListSid;

    public IpAddressList(TwilioRestClient client) {
        super(client);
    }

    public IpAddressList(TwilioRestClient client, String ipAccessControlListSid) {
        super(client);
        if (ipAccessControlListSid == null) {
            throw new IllegalStateException("The Sid for an ip access control list can not be null");
        }
        this.ipAccessControlListSid = ipAccessControlListSid;
    }

    public IpAddressList(TwilioRestClient client, Map<String, String> filters) {
        super(client, filters);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SIP/IpAccessControlLists/" + this.getIpAccessControlListSid() + "/IpAddresses" + ".json";
    }

    @Override
    protected IpAddress makeNew(TwilioRestClient client, Map<String, Object> params) {
        return new IpAddress(client, params);
    }

    @Override
    protected String getListKey() {
        return "ip_addresses";
    }

    protected String getIpAccessControlListSid() {
        return this.ipAccessControlListSid;
    }

    @Override
    public IpAddress create(Map<String, String> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioRestClient)this.getClient(), response.toMap());
    }

    @Override
    public IpAddress create(List<NameValuePair> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioRestClient)this.getClient(), response.toMap());
    }
}

