/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.hadoop.compression.lzo.LzoCodec;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreTestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CoreTestUtil.class);

    public static String getTestDataDir(Class<?> testClass) {
        return System.getProperty("test.build.data") + "/" + testClass.getSimpleName();
    }

    public static boolean okToRunLzoTests(Configuration conf) throws IOException {
        if (Boolean.parseBoolean(System.getProperty("require.lzo.tests"))) {
            return true;
        }
        try {
            return LzoCodec.isNativeLzoLoaded((Configuration)conf);
        }
        catch (UnsatisfiedLinkError e) {
            LOG.warn("Unable to load native LZO, skipping tests that require it.", (Throwable)e);
            return false;
        }
    }
}

