/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class TaskHeartbeatThread {
    private final AtomicInteger latch = new AtomicInteger();
    private final Thread beat;

    public TaskHeartbeatThread(final TaskAttemptContext context, final long periodMillis) {
        this.beat = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean interrupted = false;
                while (TaskHeartbeatThread.this.latch.get() == 0 && !interrupted) {
                    try {
                        Thread.sleep(periodMillis);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                    context.progress();
                    TaskHeartbeatThread.this.progress();
                }
            }
        });
    }

    public TaskHeartbeatThread(TaskAttemptContext context) {
        this(context, 60000L);
    }

    public void start() {
        this.beat.start();
    }

    public void stop() {
        this.latch.incrementAndGet();
        this.beat.interrupt();
    }

    protected void progress() {
    }
}

