/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class W3CLogParser {
    protected static final Logger LOG = LoggerFactory.getLogger(W3CLogParser.class);
    private Map<String, List<String>> fieldDef_ = Maps.newHashMap();
    private static final String DELIMITER = "\\s+";

    public W3CLogParser(InputStream is) throws IOException {
        String line;
        BufferedReader buf = new BufferedReader(new InputStreamReader(is));
        while ((line = buf.readLine()) != null) {
            List<String> fields = Arrays.asList(line.split(DELIMITER));
            this.fieldDef_.put(fields.get(0), fields.subList(1, fields.size()));
        }
    }

    public Map<String, String> parse(String line) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> fields = Arrays.asList(line.split(DELIMITER));
        List<String> fieldNames = this.fieldDef_.get(fields.get(0));
        if (fieldNames == null) {
            throw new IOException("cannot find matching field definition for CRC " + fields.get(0));
        }
        if (fieldNames.size() != fields.size()) {
            throw new IOException("W3C field definition and input line for CRC " + fields.get(0) + " does not match:\n" + line);
        }
        for (int fieldNum = 1; fieldNum < fieldNames.size(); ++fieldNum) {
            map.put(fieldNames.get(fieldNum), fields.get(fieldNum));
        }
        return map;
    }
}

