/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapred.input;

import com.twitter.elephantbird.mapred.input.DeprecatedInputFormatValueCopier;
import com.twitter.elephantbird.mapreduce.input.MapredInputFormatCompatible;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.HadoopUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;

public class DeprecatedInputFormatWrapper<K, V>
implements org.apache.hadoop.mapred.InputFormat<K, V> {
    private static final String CLASS_CONF_KEY = "elephantbird.class.for.DeprecatedInputFormatWrapper";
    private static final String VALUE_COPY_CONF_KEY = "elephantbird.class.for.ValueCopyClass";
    protected InputFormat<K, V> realInputFormat;
    protected DeprecatedInputFormatValueCopier<V> valueCopier = null;

    public static void setInputFormat(Class<?> realInputFormatClass, JobConf jobConf) {
        jobConf.setInputFormat(DeprecatedInputFormatWrapper.class);
        HadoopUtils.setClassConf((Configuration)jobConf, CLASS_CONF_KEY, realInputFormatClass);
    }

    public static void setInputFormat(Class<?> realInputFormatClass, JobConf jobConf, Class<? extends DeprecatedInputFormatValueCopier<?>> valueCopyClass) {
        jobConf.setInputFormat(DeprecatedInputFormatWrapper.class);
        HadoopUtils.setClassConf((Configuration)jobConf, CLASS_CONF_KEY, realInputFormatClass);
        HadoopUtils.setClassConf((Configuration)jobConf, VALUE_COPY_CONF_KEY, valueCopyClass);
    }

    public void setInputFormatInstance(InputFormat<K, V> inputFormat) {
        this.realInputFormat = inputFormat;
    }

    private void initInputFormat(JobConf conf) {
        if (this.realInputFormat == null) {
            Class copierClass;
            this.realInputFormat = (InputFormat)ReflectionUtils.newInstance((Class)conf.getClass(CLASS_CONF_KEY, null, InputFormat.class), (Configuration)conf);
            if (conf.get(VALUE_COPY_CONF_KEY) != null && null != (copierClass = conf.getClass(VALUE_COPY_CONF_KEY, null, DeprecatedInputFormatValueCopier.class))) {
                this.valueCopier = (DeprecatedInputFormatValueCopier)ReflectionUtils.newInstance((Class)copierClass, (Configuration)conf);
            }
        }
    }

    public DeprecatedInputFormatWrapper() {
    }

    public DeprecatedInputFormatWrapper(InputFormat<K, V> realInputFormat) {
        this.realInputFormat = realInputFormat;
    }

    public org.apache.hadoop.mapred.RecordReader<K, V> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf job, Reporter reporter) throws IOException {
        this.initInputFormat(job);
        return new RecordReaderWrapper<K, V>(this.realInputFormat, split, job, reporter, this.valueCopier);
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        this.initInputFormat(job);
        try {
            List splits = this.realInputFormat.getSplits(HadoopCompat.newJobContext((Configuration)job, null));
            if (splits == null) {
                return null;
            }
            org.apache.hadoop.mapred.InputSplit[] resultSplits = new org.apache.hadoop.mapred.InputSplit[splits.size()];
            int i = 0;
            for (InputSplit split : splits) {
                if (split.getClass() == FileSplit.class) {
                    FileSplit mapreduceFileSplit = (FileSplit)split;
                    resultSplits[i++] = new org.apache.hadoop.mapred.FileSplit(mapreduceFileSplit.getPath(), mapreduceFileSplit.getStart(), mapreduceFileSplit.getLength(), mapreduceFileSplit.getLocations());
                    continue;
                }
                resultSplits[i++] = new InputSplitWrapper(split);
            }
            return resultSplits;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private static class InputSplitWrapper
    implements org.apache.hadoop.mapred.InputSplit {
        InputSplit realSplit;

        public InputSplitWrapper() {
        }

        public InputSplitWrapper(InputSplit realSplit) {
            this.realSplit = realSplit;
        }

        public long getLength() throws IOException {
            try {
                return this.realSplit.getLength();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public String[] getLocations() throws IOException {
            try {
                return this.realSplit.getLocations();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public void readFields(DataInput in) throws IOException {
            Class<?> splitClass;
            String className = WritableUtils.readString((DataInput)in);
            try {
                splitClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            this.realSplit = (InputSplit)ReflectionUtils.newInstance(splitClass, null);
            ((Writable)this.realSplit).readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            WritableUtils.writeString((DataOutput)out, (String)this.realSplit.getClass().getName());
            ((Writable)this.realSplit).write(out);
        }
    }

    private static class RecordReaderWrapper<K, V>
    implements org.apache.hadoop.mapred.RecordReader<K, V> {
        private RecordReader<K, V> realReader;
        private MapredInputFormatCompatible mifcReader = null;
        private long splitLen;
        private K keyObj = null;
        private V valueObj = null;
        private boolean firstRecord = false;
        private boolean eof = false;
        private DeprecatedInputFormatValueCopier<V> valueCopier = null;

        public RecordReaderWrapper(InputFormat<K, V> newInputFormat, org.apache.hadoop.mapred.InputSplit oldSplit, JobConf oldJobConf, Reporter reporter, DeprecatedInputFormatValueCopier<V> valueCopier) throws IOException {
            this.valueCopier = valueCopier;
            this.splitLen = oldSplit.getLength();
            Object split = oldSplit.getClass() == org.apache.hadoop.mapred.FileSplit.class ? new FileSplit(((org.apache.hadoop.mapred.FileSplit)oldSplit).getPath(), ((org.apache.hadoop.mapred.FileSplit)oldSplit).getStart(), ((org.apache.hadoop.mapred.FileSplit)oldSplit).getLength(), oldSplit.getLocations()) : ((InputSplitWrapper)oldSplit).realSplit;
            TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)oldJobConf.get("mapred.task.id"));
            if (taskAttemptID == null) {
                taskAttemptID = new TaskAttemptID();
            }
            MapContext taskContext = HadoopCompat.newMapContext((Configuration)oldJobConf, (TaskAttemptID)taskAttemptID, null, null, null, (StatusReporter)new ReporterWrapper(reporter), null);
            try {
                this.realReader = newInputFormat.createRecordReader(split, (TaskAttemptContext)taskContext);
                this.realReader.initialize(split, (TaskAttemptContext)taskContext);
                if (this.realReader instanceof MapredInputFormatCompatible) {
                    this.mifcReader = (MapredInputFormatCompatible)this.realReader;
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        private void initKeyValueObjects() {
            try {
                if (!this.firstRecord & !this.eof) {
                    if (this.realReader.nextKeyValue()) {
                        this.firstRecord = true;
                        this.keyObj = this.realReader.getCurrentKey();
                        this.valueObj = this.realReader.getCurrentValue();
                    } else {
                        this.eof = true;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read first record (and it was not an EOF)", e);
            }
        }

        public void close() throws IOException {
            this.realReader.close();
        }

        public K createKey() {
            this.initKeyValueObjects();
            return this.keyObj;
        }

        public V createValue() {
            this.initKeyValueObjects();
            return this.valueObj;
        }

        public long getPos() throws IOException {
            return (long)((float)this.splitLen * this.getProgress());
        }

        public float getProgress() throws IOException {
            try {
                return this.realReader.getProgress();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public boolean next(K key, V value) throws IOException {
            if (this.eof) {
                return false;
            }
            if (this.firstRecord) {
                this.firstRecord = false;
                return true;
            }
            if (this.mifcReader != null) {
                this.mifcReader.setKeyValue(key, value);
            }
            try {
                if (this.realReader.nextKeyValue()) {
                    if (key != this.realReader.getCurrentKey()) {
                        if (this.mifcReader != null) {
                            throw new IOException("The RecordReader returned a key and value that do not match the key and value sent to it. This means the RecordReader did not properly implement com.twitter.elephantbird.mapred.input.MapredInputFormatCompatible. Current reader class : " + this.realReader.getClass());
                        }
                        throw new IOException("DeprecatedInputFormatWrapper only supports RecordReaders that return the same key & value objects or implement com.twitter.elephantbird.mapred.input.MapredInputFormatCompatible. Current reader class : " + this.realReader.getClass());
                    }
                    if (value != this.realReader.getCurrentValue()) {
                        if (null != this.valueCopier) {
                            this.valueCopier.copyValue(value, this.realReader.getCurrentValue());
                        } else {
                            throw new IOException("DeprecatedInputFormatWrapper - value is different and no value copier provided. Current reader class : " + this.realReader.getClass());
                        }
                    }
                    return true;
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.eof = true;
            return false;
        }
    }

    public static class ReporterWrapper
    extends StatusReporter
    implements Reporter {
        private Reporter wrappedReporter;

        public ReporterWrapper(Reporter reporter) {
            this.wrappedReporter = reporter;
        }

        public Counters.Counter getCounter(Enum<?> anEnum) {
            return this.wrappedReporter.getCounter(anEnum);
        }

        public Counters.Counter getCounter(String s, String s1) {
            return this.wrappedReporter.getCounter(s, s1);
        }

        public void incrCounter(Enum<?> anEnum, long l) {
            this.wrappedReporter.incrCounter(anEnum, l);
        }

        public void incrCounter(String s, String s1, long l) {
            this.wrappedReporter.incrCounter(s, s1, l);
        }

        public org.apache.hadoop.mapred.InputSplit getInputSplit() throws UnsupportedOperationException {
            return this.wrappedReporter.getInputSplit();
        }

        public void progress() {
            this.wrappedReporter.progress();
        }

        public float getProgress() {
            throw new UnsupportedOperationException();
        }

        public void setStatus(String s) {
            this.wrappedReporter.setStatus(s);
        }
    }
}

