/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.io;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import com.twitter.elephantbird.mapreduce.io.SerializedBlock;
import com.twitter.elephantbird.util.Protobufs;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class BinaryBlockWriter<M> {
    protected static final int DEFAULT_NUM_RECORDS_PER_BLOCK = 100;
    private final OutputStream out_;
    private final int numRecordsPerBlock_;
    protected final Class<M> innerClass_;
    private final BinaryConverter<M> binaryConverter_;
    private int numRecordsWritten_ = 0;
    private List<ByteString> protoBlobs_;

    protected BinaryBlockWriter(OutputStream out, Class<M> protoClass, BinaryConverter<M> binaryConverter, int numRecordsPerBlock) {
        this.out_ = out;
        this.numRecordsPerBlock_ = numRecordsPerBlock;
        this.innerClass_ = protoClass;
        this.binaryConverter_ = binaryConverter;
        this.protoBlobs_ = new ArrayList<ByteString>(this.numRecordsPerBlock_);
    }

    public void write(M message) throws IOException {
        if (message instanceof Message) {
            this.protoBlobs_.add(((Message)message).toByteString());
        } else {
            this.protoBlobs_.add(ByteString.copyFrom((byte[])this.binaryConverter_.toBytes(message)));
        }
        ++this.numRecordsWritten_;
        if (this.protoBlobs_.size() == this.numRecordsPerBlock_) {
            this.serialize();
        }
    }

    public void finish() throws IOException {
        if (this.protoBlobs_.size() > 0) {
            this.serialize();
        }
    }

    public void close() throws IOException {
        this.finish();
        this.out_.close();
    }

    protected void serialize() throws IOException {
        this.out_.write(Protobufs.KNOWN_GOOD_POSITION_MARKER);
        Message block = SerializedBlock.newInstance(this.innerClass_.getCanonicalName(), this.protoBlobs_).getMessage();
        this.protoBlobs_ = new ArrayList<ByteString>(this.numRecordsPerBlock_);
        this.writeRawLittleEndian32(block.getSerializedSize());
        block.writeTo(this.out_);
    }

    private void writeRawLittleEndian32(int size) throws IOException {
        this.out_.write(size & 0xFF);
        this.out_.write(size >> 8 & 0xFF);
        this.out_.write(size >> 16 & 0xFF);
        this.out_.write(size >> 24 & 0xFF);
    }
}

